/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.model;

public class OutputDTO<T> {
    private Integer code;
    private String message;
    private T data;

    OutputDTO(T data) {
        this.data = data;
        this.code = 0;
        this.message = "SUCCESS";
    }

    private OutputDTO(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    public static <T> OutputDTO<T> ok(T data) {
        return new OutputDTO<T>(data);
    }

    public static <T> OutputDTO<T> ok(int success, T data) {
        OutputDTO<T> result = new OutputDTO<T>(data);
        result.setCode(success);
        return result;
    }

    public static OutputDTO<Void> error(int code, String msg) {
        return new OutputDTO<Void>(code, msg);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputDTO)) {
            return false;
        }
        OutputDTO other = (OutputDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OutputDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "OutputDTO(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

