/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.core.Cache;
import cn.flyelf.cache.core.model.CacheTestModel;
import cn.flyelf.cache.sample.util.ModelUtil;
import cn.flyelf.cache.spring.annotation.ConcurrencyApi;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/cache/simple"})
public class CacheSimpleController {
    private static final Logger log = LoggerFactory.getLogger(CacheSimpleController.class);
    @CacheBean(layer={"caffeine"})
    private Cache<String, CacheTestModel> cacheCaffeine;
    @CacheBean
    private Cache<String, CacheTestModel> cacheRedis;

    @GetMapping(value={"/caffeine/put/{key}"})
    @ConcurrencyApi(value="#id", timeout=1000000L)
    public Mono<CacheTestModel> putSimpleCaffeine(@PathVariable(value="key") String key, @RequestParam(value="duration", required=false) Long duration, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        return this.putModel(key, duration, this.cacheCaffeine, id, name, index);
    }

    @GetMapping(value={"/caffeine/get2/{key}"})
    @ConcurrencyApi
    public CacheTestModel getSimpleCaffeine2(@PathVariable(value="key") String key) {
        return (CacheTestModel)this.cacheCaffeine.get((Object)key).block();
    }

    @GetMapping(value={"/caffeine/get/{key}"})
    @ConcurrencyApi
    public Mono<CacheTestModel> getSimpleCaffeine(@PathVariable(value="key") String key) {
        return this.cacheCaffeine.get((Object)key);
    }

    private Mono<CacheTestModel> putModel(String key, Long duration, Cache<String, CacheTestModel> cache, long id, String name, Integer index) {
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        Mono result = cache.put((Object)key, (Object)model, duration, TimeUnit.SECONDS);
        return result.map(r -> model);
    }

    @GetMapping(value={"/redis/put/{key}"})
    public Mono<CacheTestModel> putRedis(@PathVariable(value="key") String key, @RequestParam(value="duration") Long duration, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        return this.putModel(key, duration, this.cacheRedis, id, name, index);
    }

    @GetMapping(value={"/redis/get/{key}"})
    public Mono<CacheTestModel> getRedis(@PathVariable(value="key") String key) {
        return this.cacheRedis.get((Object)key);
    }

    @GetMapping(value={"/redis/block/{key}"})
    public CacheTestModel blockRedis(@PathVariable(value="key") String key) {
        Mono result = this.cacheRedis.get((Object)key);
        return (CacheTestModel)result.block();
    }

    @GetMapping(value={"/redis/load/{key}"})
    public Mono<CacheTestModel> getRedisNullAndLoad(@PathVariable(value="key") String key, @RequestParam(value="id", required=false) Long id, @RequestParam(value="name", required=false) String name, @RequestParam(value="index", required=false) Integer index) {
        CacheTestModel model = null;
        if (null != id) {
            model = ModelUtil.buildModel(id, name, index);
        }
        CacheTestModel finalModel = model;
        return this.cacheRedis.get((Object)key, k -> finalModel);
    }
}

