/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.core.SetCache;
import cn.flyelf.cache.core.model.CacheTestModel;
import cn.flyelf.cache.sample.util.ModelUtil;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/cache/set"})
public class CacheSetController {
    private static final Logger log = LoggerFactory.getLogger(CacheSetController.class);
    @CacheBean(layer={"caffeine"})
    private SetCache<String, CacheTestModel> cacheSetCaffeine;
    @CacheBean
    private SetCache<String, CacheTestModel> cacheSetRedis;

    @GetMapping(value={"/caffeine/put/{key}"})
    public Flux<CacheTestModel> putCaffeineSet(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index, @RequestParam(value="duration", required=false) Long duration) {
        return this.putSet(this.cacheSetCaffeine, key, id, name, index, duration);
    }

    private Flux<CacheTestModel> putSet(SetCache<String, CacheTestModel> cache, String key, long[] id, String[] name, Integer[] index, Long duration) {
        HashSet<CacheTestModel> models = new HashSet<CacheTestModel>();
        return ModelUtil.putCollection(cache, models, key, id, name, index, duration);
    }

    @GetMapping(value={"/caffeine/get/{key}"})
    public Flux<CacheTestModel> getCaffeineSet(@PathVariable(value="key") String key) {
        log.info("\u7f13\u5b58\u63a5\u53e3\uff1acaffeine/set/get, key = {}", (Object)key);
        Mono result = this.cacheSetCaffeine.get((Object)key);
        return result.flatMapMany(Flux::fromIterable);
    }

    @GetMapping(value={"/redis/put/{key}"})
    public Flux<CacheTestModel> putRedisSet(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index, @RequestParam(value="duration", required=false) Long duration) {
        return this.putSet(this.cacheSetRedis, key, id, name, index, duration);
    }

    @GetMapping(value={"/redis/get/{key}"})
    public Flux<CacheTestModel> getRedisSet(@PathVariable(value="key") String key) {
        Mono result = this.cacheSetRedis.get((Object)key);
        return result.flatMapMany(Flux::fromIterable);
    }
}

