/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.core.Cache;
import cn.flyelf.cache.core.model.CacheTestModel;
import cn.flyelf.cache.sample.util.ModelUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/cache/both"})
public class CacheBothController {
    private static final Logger log = LoggerFactory.getLogger(CacheBothController.class);
    @CacheBean(layer={"caffeine", "redis"})
    private Cache<String, List<CacheTestModel>> cacheListBoth;
    @CacheBean(layer={"caffeine", "redis"}, expire={20L, 600L})
    private Cache<String, CacheTestModel> cacheSimpleBoth;

    @GetMapping(value={"/list/put/{key}"})
    public Flux<CacheTestModel> putBothList(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index, @RequestParam(value="duration", required=false) Long duration) {
        ArrayList<CacheTestModel> models = new ArrayList<CacheTestModel>(id.length);
        return ModelUtil.putCollection(this.cacheListBoth, models, key, id, name, index, duration);
    }

    @GetMapping(value={"/list/get/{key}"})
    public Flux<CacheTestModel> getBothList(@PathVariable(value="key") String key) {
        Mono result = this.cacheListBoth.get((Object)key);
        return result.flatMapMany(Flux::fromIterable);
    }

    @GetMapping(value={"/simple/put/{key}"})
    public Mono<Boolean> putBothSimple(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        return this.cacheSimpleBoth.put((Object)key, (Object)model);
    }

    @GetMapping(value={"/simple/get/{key}"})
    public Mono<CacheTestModel> getBothSimple(@PathVariable(value="key") String key) {
        return this.cacheSimpleBoth.get((Object)key);
    }
}

