/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.advice;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.regex.Pattern;

public class TimeConverter {
    private static final ConcurrentHashMap<String, DateTimeFormatter> DAY_FORMATTER = new ConcurrentHashMap(3);
    private static final ConcurrentHashMap<String, DateTimeFormatter> MONTH_FORMATTER = new ConcurrentHashMap(3);
    private static final ConcurrentHashMap<String, DateTimeFormatter> SECOND_FORMATTER = new ConcurrentHashMap(3);
    private static final ConcurrentHashMap<String, DateTimeFormatter> MINUTE_FORMATTER = new ConcurrentHashMap(3);
    private static final ConcurrentHashMap<String, DateTimeFormatter> HOUR_FORMATTER = new ConcurrentHashMap(3);
    private static final ConcurrentHashMap<String, DateTimeFormatter> TIME_FORMATTER = new ConcurrentHashMap(1);
    private static final Pattern[] PATTERN_FORMAT = new Pattern[]{Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$"), Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$"), Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}$"), Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}$"), Pattern.compile("^\\d{4}-\\d{1,2}$")};
    private static final List<BiFunction<String, String, Date>> FORMATTERS = Arrays.asList(TimeConverter::second, TimeConverter::minute, TimeConverter::hour, TimeConverter::day, TimeConverter::month);

    private static String format(DateTimeFormatter formatter, Date date) {
        return formatter.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    public static String day(Date date, String separator) {
        DateTimeFormatter formatter = DAY_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd"));
        return TimeConverter.format(formatter, date);
    }

    public static Date day(String date, String separator) {
        DateTimeFormatter formatter = DAY_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd"));
        LocalDate localDate = LocalDate.parse(date, formatter);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static String month(Date date, String separator) {
        DateTimeFormatter formatter = MONTH_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM"));
        return TimeConverter.format(formatter, date);
    }

    public static Date month(String date, String separator) {
        String[] values = date.split(separator);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(values[0]));
        calendar.set(2, Integer.parseInt(values[1]) - 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static String second(Date date, String separator) {
        DateTimeFormatter formatter = SECOND_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd HH:mm:ss"));
        return TimeConverter.format(formatter, date);
    }

    public static Date second(String date, String separator) {
        DateTimeFormatter formatter = SECOND_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd HH:mm:ss"));
        LocalDateTime localDateTime = LocalDateTime.parse(date, formatter);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String minute(Date date, String separator) {
        DateTimeFormatter formatter = MINUTE_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd HH:mm"));
        return TimeConverter.format(formatter, date);
    }

    public static Date minute(String date, String separator) {
        DateTimeFormatter formatter = MINUTE_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd HH:mm"));
        LocalDateTime localDateTime = LocalDateTime.parse(date, formatter);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String hour(Date date, String separator) {
        DateTimeFormatter formatter = HOUR_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd HH"));
        return TimeConverter.format(formatter, date);
    }

    public static Date hour(String date, String separator) {
        DateTimeFormatter formatter = HOUR_FORMATTER.computeIfAbsent(separator, k -> DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd HH"));
        LocalDateTime localDateTime = LocalDateTime.parse(date, formatter);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String time(Date date, String format) {
        DateTimeFormatter formatter = TIME_FORMATTER.computeIfAbsent(format, DateTimeFormatter::ofPattern);
        return TimeConverter.format(formatter, date);
    }

    public static Date time(String time) {
        for (int index = 0; index < PATTERN_FORMAT.length; ++index) {
            Pattern pattern = PATTERN_FORMAT[index];
            if (!pattern.matcher(time).matches()) continue;
            BiFunction<String, String, Date> function = FORMATTERS.get(index);
            return function.apply(time, "-");
        }
        return null;
    }

    public static Calendar nextDay() {
        Calendar calendar = Calendar.getInstance();
        TimeConverter.nextDay(calendar);
        return calendar;
    }

    public static void nextDay(Calendar calendar) {
        calendar.add(5, 1);
        TimeConverter.clearDay(calendar);
    }

    public static void clearDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date clearDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        TimeConverter.clearDay(calendar);
        return calendar.getTime();
    }

    public static Date lastDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }
}

