/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.persistence.query;

import cn.featherfly.common.db.builder.ConditionBuilder;
import cn.featherfly.common.db.builder.LogicBuilder;
import cn.featherfly.common.db.operator.LogicOperator;
import cn.featherfly.common.db.operator.QueryOperator;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.persistence.query.Query;
import java.util.List;

public abstract class AbstractQuery<Q extends AbstractQuery<Q, E>, E>
implements Query<Q, E> {
    protected ConditionBuilder conditionBuilder = new ConditionBuilder();
    private LogicBuilder logicBuilder;
    private int maxResult = -1;
    private int firstResult;
    private PaginationResults<E> pagination;

    public AbstractQuery() {
        this.conditionBuilder.setBuildWithWhere(true);
    }

    @Override
    public Q setMaxResult(int maxResult) {
        this.maxResult = maxResult;
        return (Q)this;
    }

    @Override
    public Q setFirstResult(int first) {
        this.firstResult = first;
        return (Q)this;
    }

    @Override
    public Q setPagination(PaginationResults<E> pagination) {
        this.pagination = pagination;
        return (Q)this;
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public PaginationResults<E> getPagination() {
        return this.pagination;
    }

    protected Q addCondition(String name, Object value, QueryOperator queryOperator, LogicOperator logicOperator) {
        if (this.logicBuilder != null) {
            if (logicOperator == LogicOperator.AND) {
                this.and();
            } else {
                this.or();
            }
        }
        this.logicBuilder = this.conditionBuilder.add(name, value, queryOperator);
        return (Q)this;
    }

    protected Q lt(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.lt, logicOperator);
        return (Q)this;
    }

    protected Q le(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.le, logicOperator);
        return (Q)this;
    }

    protected Q eq(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.eq, logicOperator);
        return (Q)this;
    }

    protected Q ne(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.ne, logicOperator);
        return (Q)this;
    }

    protected Q ge(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.ge, logicOperator);
        return (Q)this;
    }

    protected Q gt(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.gt, logicOperator);
        return (Q)this;
    }

    protected Q sw(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.sw, logicOperator);
        return (Q)this;
    }

    protected Q co(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.co, logicOperator);
        return (Q)this;
    }

    protected Q ew(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.ew, logicOperator);
        return (Q)this;
    }

    protected Q in(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.in, logicOperator);
        return (Q)this;
    }

    protected Q nin(String name, Object value, LogicOperator logicOperator) {
        this.addCondition(name, value, QueryOperator.in, logicOperator);
        return (Q)this;
    }

    protected Q isn(String name, LogicOperator logicOperator) {
        this.addCondition(name, null, QueryOperator.isn, logicOperator);
        return (Q)this;
    }

    protected Q inn(String name, LogicOperator logicOperator) {
        this.addCondition(name, null, QueryOperator.inn, logicOperator);
        return (Q)this;
    }

    public Q asc(String ... names) {
        this.conditionBuilder.asc(names);
        return (Q)this;
    }

    public Q desc(String ... names) {
        this.conditionBuilder.desc(names);
        return (Q)this;
    }

    public Q ascFirst(String ... names) {
        this.conditionBuilder.ascFirst(names);
        return (Q)this;
    }

    public Q descFirst(String ... names) {
        this.conditionBuilder.descFirst(names);
        return (Q)this;
    }

    public Q clearOrders() {
        this.conditionBuilder.clearOrders();
        return (Q)this;
    }

    protected List<Object> getParams() {
        return this.conditionBuilder.getParams();
    }

    protected String getCondition() {
        return this.conditionBuilder.build();
    }

    protected abstract String getAlias();

    protected void and() {
        if (this.logicBuilder != null) {
            this.logicBuilder.and();
        }
    }

    protected void or() {
        if (this.logicBuilder != null) {
            this.logicBuilder.or();
        }
    }
}

