/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.persistence;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.persistence.PersistenceBatch;
import cn.featherfly.persistence.PersistenceEventListener;
import cn.featherfly.persistence.event.PersistenceExecuteBatchEvent;
import cn.featherfly.persistence.event.PersistenceExecuteEvent;
import cn.featherfly.persistence.event.PersistenceGetEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceObserver
implements PersistenceBatch {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<PersistenceEventListener> listeners = new ArrayList<PersistenceEventListener>();

    @Override
    public <E> void persist(E entity) {
        PersistenceExecuteEvent<E> event = new PersistenceExecuteEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setEntity(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforePersist, listener: {}" + listener.getClass().getName());
            listener.onBeforePersist(event);
        }
        this.doPersist(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterPersist, listener: {}" + listener.getClass().getName());
            listener.onAfterPersist(event);
        }
    }

    @Override
    public <E> void save(E entity) {
        PersistenceExecuteEvent<E> event = new PersistenceExecuteEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setEntity(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeSave, listener: {}" + listener.getClass().getName());
            listener.onBeforeSave(event);
        }
        this.doSave(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterSave, listener: {}" + listener.getClass().getName());
            listener.onAfterSave(event);
        }
    }

    @Override
    public <E> void update(E entity) {
        PersistenceExecuteEvent<E> event = new PersistenceExecuteEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setEntity(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeUpdate, listener: {}" + listener.getClass().getName());
            listener.onBeforeUpdate(event);
        }
        this.doUpdate(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterUpdate, listener: {}" + listener.getClass().getName());
            listener.onAfterUpdate(event);
        }
    }

    @Override
    public <E> void saveOrUpdate(E entity) {
        PersistenceExecuteEvent<E> event = new PersistenceExecuteEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setEntity(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeSaveOrUpdate, listener: {}" + listener.getClass().getName());
            listener.onBeforeSaveOrUpdate(event);
        }
        this.doSaveOrUpdate(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterSaveOrUpdate, listener: {}" + listener.getClass().getName());
            listener.onAfterSaveOrUpdate(event);
        }
    }

    @Override
    public <E> void saveOrMerge(E entity) {
        PersistenceExecuteEvent<E> event = new PersistenceExecuteEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setEntity(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeSaveOrMerge, listener: {}" + listener.getClass().getName());
            listener.onBeforeSaveOrMerge(event);
        }
        this.doSaveOrMerge(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterSaveOrMerge, listener: {}" + listener.getClass().getName());
            listener.onAfterSaveOrMerge(event);
        }
    }

    @Override
    public <E> void delete(E entity) {
        PersistenceExecuteEvent<E> event = new PersistenceExecuteEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setEntity(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeDelete, listener: {}" + listener.getClass().getName());
            listener.onBeforeDelete(event);
        }
        this.doDelete(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterDelete, listener: {}" + listener.getClass().getName());
            listener.onAfterDelete(event);
        }
    }

    @Override
    public <E> void merge(E entity) {
        PersistenceExecuteEvent<E> event = new PersistenceExecuteEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setEntity(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeMerge, listener: {}" + listener.getClass().getName());
            listener.onBeforeMerge(event);
        }
        this.doMerge(entity);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterMerge, listener: {}" + listener.getClass().getName());
            listener.onAfterMerge(event);
        }
    }

    @Override
    public <E> E get(Serializable id, Class<E> type) {
        PersistenceGetEvent<E> event = new PersistenceGetEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setIdentity(id);
        event.setType(type);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeGet, listener: {}" + listener.getClass().getName());
            listener.onBeforeGet(event);
        }
        E e = this.doGet(id, type);
        event.setEntity(e);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterGet, listener: {}" + listener.getClass().getName());
            listener.onAfterGet(event);
        }
        return e;
    }

    @Override
    public <E> E load(E entity) {
        PersistenceGetEvent<E> event = new PersistenceGetEvent<E>();
        event.setDataSource(this.getDataSource());
        event.setIdentity(this.getIdentity(entity));
        event.setEntity(entity);
        if (entity != null) {
            event.setType(ClassUtils.castGenericType(entity.getClass(), entity));
        }
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeLoad, listener: {}" + listener.getClass().getName());
            listener.onBeforeLoad(event);
        }
        E e = this.doLoad(entity);
        event.setEntity(e);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterLoad, listener: {}" + listener.getClass().getName());
            listener.onAfterLoad(event);
        }
        return e;
    }

    @Override
    public <E> void deleteBatch(List<E> entityList) {
        PersistenceExecuteBatchEvent<E> event = new PersistenceExecuteBatchEvent<E>();
        event.setDataSource(this.getDataSource());
        event.addEntitys(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeDeleteBatch, listener: {}" + listener.getClass().getName());
            listener.onBeforeDeleteBatch(event);
        }
        this.doDeleteBatch(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterDeleteBatch, listener: {}" + listener.getClass().getName());
            listener.onAfterDeleteBatch(event);
        }
    }

    @Override
    public <E> void mergeBatch(List<E> entityList) {
        PersistenceExecuteBatchEvent<E> event = new PersistenceExecuteBatchEvent<E>();
        event.setDataSource(this.getDataSource());
        event.addEntitys(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeMergeBatch, listener: {}" + listener.getClass().getName());
            listener.onBeforeMergeBatch(event);
        }
        this.doMergeBatch(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterMergeBatch, listener: {}" + listener.getClass().getName());
            listener.onAfterMergeBatch(event);
        }
    }

    @Override
    public <E> void persistBatch(List<E> entityList) {
        PersistenceExecuteBatchEvent<E> event = new PersistenceExecuteBatchEvent<E>();
        event.setDataSource(this.getDataSource());
        event.addEntitys(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforePersistBatch, listener: {}" + listener.getClass().getName());
            listener.onBeforePersistBatch(event);
        }
        this.doPersistBatch(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterPersistBatch, listener: {}" + listener.getClass().getName());
            listener.onAfterPersistBatch(event);
        }
    }

    @Override
    public <E> void saveBatch(List<E> entityList) {
        PersistenceExecuteBatchEvent<E> event = new PersistenceExecuteBatchEvent<E>();
        event.setDataSource(this.getDataSource());
        event.addEntitys(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeSaveBatch, listener: {}" + listener.getClass().getName());
            listener.onBeforeSaveBatch(event);
        }
        this.doSaveBatch(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterSaveBatch, listener: {}" + listener.getClass().getName());
            listener.onAfterSaveBatch(event);
        }
    }

    @Override
    public <E> void saveOrMergeBatch(List<E> entityList) {
        PersistenceExecuteBatchEvent<E> event = new PersistenceExecuteBatchEvent<E>();
        event.setDataSource(this.getDataSource());
        event.addEntitys(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeSaveOrMergeBatch, listener: {}" + listener.getClass().getName());
            listener.onBeforeSaveOrMergeBatch(event);
        }
        this.doSaveOrMergeBatch(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterSaveOrMergeBatch, listener: {}" + listener.getClass().getName());
            listener.onAfterSaveOrMergeBatch(event);
        }
    }

    @Override
    public <E> void saveOrUpdateBatch(List<E> entityList) {
        PersistenceExecuteBatchEvent<E> event = new PersistenceExecuteBatchEvent<E>();
        event.setDataSource(this.getDataSource());
        event.addEntitys(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeSaveOrUpdateBatch, listener: {}" + listener.getClass().getName());
            listener.onBeforeSaveOrUpdateBatch(event);
        }
        this.doSaveOrUpdateBatch(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterSaveOrUpdateBatch, listener: {}" + listener.getClass().getName());
            listener.onAfterSaveOrUpdateBatch(event);
        }
    }

    @Override
    public <E> void updateBatch(List<E> entityList) {
        PersistenceExecuteBatchEvent<E> event = new PersistenceExecuteBatchEvent<E>();
        event.setDataSource(this.getDataSource());
        event.addEntitys(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onBeforeUpdateBatch, listener: {}" + listener.getClass().getName());
            listener.onBeforeUpdateBatch(event);
        }
        this.doUpdateBatch(entityList);
        for (PersistenceEventListener listener : this.listeners) {
            this.logger.debug("onAfterUpdateBatch, listener: {}" + listener.getClass().getName());
            listener.onAfterUpdateBatch(event);
        }
    }

    protected abstract <E> void doPersist(E var1);

    protected abstract <E> void doSave(E var1);

    protected abstract <E> void doUpdate(E var1);

    protected abstract <E> void doSaveOrUpdate(E var1);

    protected abstract <E> void doSaveOrMerge(E var1);

    protected abstract <E> void doDelete(E var1);

    protected abstract <E> void doMerge(E var1);

    protected abstract <E> E doGet(Serializable var1, Class<E> var2);

    protected abstract <E> E doLoad(E var1);

    protected abstract <E> void doPersistBatch(List<E> var1);

    protected abstract <E> void doSaveBatch(List<E> var1);

    protected abstract <E> void doUpdateBatch(List<E> var1);

    protected abstract <E> void doSaveOrUpdateBatch(List<E> var1);

    protected abstract <E> void doSaveOrMergeBatch(List<E> var1);

    protected abstract <E> void doDeleteBatch(List<E> var1);

    protected abstract <E> void doMergeBatch(List<E> var1);

    public void addListener(PersistenceEventListener listener) {
        this.listeners.add(listener);
    }

    public void addListeners(PersistenceEventListener ... listeners) {
        this.addListeners(Arrays.asList(listeners));
    }

    public void addListeners(List<PersistenceEventListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public void removeListener(PersistenceEventListener listener) {
        this.listeners.remove(listener);
    }

    public void clearListener() {
        this.listeners.clear();
    }

    public List<PersistenceEventListener> getListeners() {
        return new ArrayList<PersistenceEventListener>(this.listeners);
    }

    public void setListeners(List<PersistenceEventListener> listeners) {
        this.listeners = listeners;
    }
}

