/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.wechat.util;

import cn.easyutil.util.javaUtil.HttpUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.ObjectUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.platform.base.PlatfromUserInfo;
import cn.easyutil.util.platform.wechat.base.WeChatAccount;
import cn.easyutil.util.platform.wechat.base.WeChatMessage;
import cn.easyutil.util.platform.wechat.util.bean.UserAccessTokenBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeChatPublicOperation {
    private String getAccessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=#{APPID}&secret=#{APPSECRET}";
    private static String getCodeUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=#{APPID}&redirect_uri=#{REDIRECT_URI}&response_type=code&scope=#{SCOPE}&state=#{STATE}#wechat_redirect";
    private String getUserAccessToken = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=#{APPID}&secret=#{APPSECRET}&code=#{CODE}&grant_type=authorization_code";
    private String refreshUserAceessToken = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=#{APPID}&grant_type=refresh_token&refresh_token=#{REFRESH_TOKEN}";
    private String getUserInfo = "https://api.weixin.qq.com/sns/userinfo?access_token=#{ACCESS_TOKEN}&openid=#{OPENID}&lang=zh_CN";
    private String sendMsg_url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=#{ACCESS_TOKEN}";
    private WeChatAccount account;

    public WeChatPublicOperation(WeChatAccount account) {
        this.account = account;
    }

    public PlatfromUserInfo login(String code) {
        return this.getUserInfo(code);
    }

    public UserAccessTokenBean getUserAccessToken(String code) {
        String url = this.getUserAccessToken.replace("#{APPID}", this.account.getAppid()).replace("#{APPSECRET}", this.account.getAppsecret()).replace("#{CODE}", code);
        String result = HttpUtil.doUrl(url, "GET");
        return JsonUtil.jsonToBean(result, UserAccessTokenBean.class);
    }

    public UserAccessTokenBean refreshUserAccessToken(String refreshToken) {
        String url = this.refreshUserAceessToken.replace("#{APPID}", this.account.getAppid()).replace("#{REFRESH_TOKEN}", refreshToken);
        String result = HttpUtil.doUrl(url, "GET");
        return JsonUtil.jsonToBean(result, UserAccessTokenBean.class);
    }

    public PlatfromUserInfo getUserInfo(String accessToken, String openid) {
        String url = this.getUserInfo.replace("#{ACCESS_TOKEN}", accessToken).replace("#{OPENID}", openid);
        String result = HttpUtil.doUrl(url, "GET");
        Map<String, Object> map = JsonUtil.jsonToMap(result);
        PlatfromUserInfo user = new PlatfromUserInfo();
        if (map.get("city") != null) {
            user.setAddress(map.get("city").toString());
        }
        if (map.get("headimgurl") != null) {
            user.setHeaderImg(map.get("headimgurl").toString());
        }
        if (map.get("nickname") != null) {
            user.setNickName(map.get("nickname").toString());
        }
        if (map.get("sex") != null) {
            String sex = map.get("sex").toString();
            user.setSex(sex.equals("1") ? 1 : 0);
        }
        if (map.get("openid") != null) {
            user.setUniqueId(map.get("openid").toString());
        }
        user.setAsAll(map);
        return user;
    }

    public PlatfromUserInfo getUserInfo(String code) {
        UserAccessTokenBean acc = this.getUserAccessToken(code);
        return this.getUserInfo(acc.getAccess_token(), acc.getOpenid());
    }

    public boolean pushMessage(String openId, String templateId, WeChatMessage message) {
        return this.pushMessage(openId, templateId, null, message);
    }

    public String getGlobalAccessToken() {
        Map<String, Object> map;
        String url = this.getAccessTokenUrl.replace("#{APPID}", this.account.getAppid()).replace("#{APPSECRET}", this.account.getAppsecret());
        String accessToken = HttpUtil.doUrl(url, "GET");
        if (accessToken != null && (map = JsonUtil.jsonToMap(accessToken)).get("access_token") != null) {
            return map.get("access_token").toString();
        }
        return null;
    }

    public boolean pushMessage(String openId, String templateId, String url, WeChatMessage message) {
        HashMap<String, Object> finalMessage = new HashMap<String, Object>();
        finalMessage.put("touser", openId);
        finalMessage.put("template_id", templateId);
        if (!StringUtil.isEmpty(url)) {
            finalMessage.put("url", url);
        }
        HashMap mess = new HashMap();
        List params = (List)ObjectUtil.getAttributeValue(message, "params");
        for (int i = 0; i < params.size(); ++i) {
            HashMap param = new HashMap();
            param.put("value", ObjectUtil.getAttributeValue(params.get(i), "value"));
            param.put("color", ObjectUtil.getAttributeValue(params.get(i), "color"));
            mess.put(ObjectUtil.getAttributeValue(params.get(i), "paramName"), param);
        }
        finalMessage.put("data", mess);
        String result = HttpUtil.doUrl(this.sendMsg_url.replace("#{ACCESS_TOKEN}", this.getGlobalAccessToken()), "POST", null, JsonUtil.beanToJson(finalMessage));
        Map<String, Object> jsonToMap = JsonUtil.jsonToMap(result);
        if (jsonToMap.get("errcode") != null && jsonToMap.get("errcode").equals(0) && jsonToMap.get("errmsg") != null && jsonToMap.get("errmsg").equals("ok")) {
            return true;
        }
        LoggerUtil.error(this.getClass(), "\u53d1\u9001\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u5931\u8d25:" + result);
        return false;
    }
}

