/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.wechat.pay;

import cn.easyutil.util.javaUtil.HttpUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.javaUtil.XmlUtil;
import cn.easyutil.util.platform.wechat.base.WeChatPayAccount;
import cn.easyutil.util.platform.wechat.base.WeChatPayStatus;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayCallBackParseBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayParamsBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayResultBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayToBankParamBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayToBankResultBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayToUserParamBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayToUserResultBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatRefundResultBean;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WeChatPayUtil {
    protected static final String RETURN_CODE = "return_code";
    protected static final String RESULT_CODE = "result_code";
    protected static final String OUT_TRADE_NO = "out_trade_no";
    protected static final String TOTAL_FEE = "total_fee";
    protected static final String SIGN = "sign";
    protected static final String RANDOMSTR = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private WeChatPayAccount account;

    public WeChatPayUtil(WeChatPayAccount account) {
        this.account = account;
    }

    public WeChatPayResultBean scannpay(WeChatPayParamsBean params) {
        Map<String, String> map = this.h5AndApppay(params, "NATIVE", null, null);
        WeChatPayResultBean bean = new WeChatPayResultBean();
        bean.setCodeUrl(map.get("code_url"));
        return bean;
    }

    public WeChatPayResultBean h5pay(WeChatPayParamsBean params) {
        Map<String, String> result = this.h5AndApppay(params, "MWEB", null, null);
        WeChatPayResultBean bean = new WeChatPayResultBean();
        bean.setPrepayId(result.get("prepay_id"));
        bean.setMwebUrl(result.get("mweb_url"));
        return bean;
    }

    public WeChatPayResultBean publicpay(WeChatPayParamsBean params) {
        if (params == null || params.getOpenId() == null) {
            throw new RuntimeException("\u7f3a\u5c11openid");
        }
        String time = (System.currentTimeMillis() + "").substring(0, 10);
        Map<String, String> result = this.h5AndApppay(params, "JSAPI", time, params.getOpenId());
        TreeMap<String, String> returnMap = new TreeMap<String, String>();
        returnMap.put("appId", this.account.getAppid());
        returnMap.put("timeStamp", time);
        returnMap.put("nonceStr", result.get("nonce_str"));
        returnMap.put("package", "prepay_id=" + result.get("prepay_id"));
        returnMap.put("signType", "MD5");
        String sign = this.createSign(returnMap, this.account.getApiKey());
        returnMap.put("paySign", sign);
        WeChatPayResultBean bean = new WeChatPayResultBean();
        bean.setPrepayId((String)returnMap.get("appId"));
        bean.setTimeStamp((String)returnMap.get("timeStamp"));
        bean.setNoncestr((String)returnMap.get("nonceStr"));
        bean.setPackageValue((String)returnMap.get("package"));
        bean.setSignType((String)returnMap.get("signType"));
        bean.setPaySign((String)returnMap.get("paySign"));
        return bean;
    }

    public WeChatPayResultBean apppay(WeChatPayParamsBean params) {
        Map<String, String> result = this.h5AndApppay(params, "APP", null, null);
        TreeMap<String, String> returnMap = new TreeMap<String, String>();
        returnMap.put("appid", this.account.getAppid());
        returnMap.put("partnerid", this.account.getMchId());
        returnMap.put("prepayid", result.get("prepay_id"));
        returnMap.put("package", "Sign=WXPay");
        returnMap.put("noncestr", StringUtil.getRandomString(32));
        returnMap.put("timestamp", (System.currentTimeMillis() + "").substring(0, 10));
        String sign = this.createSign(returnMap, this.account.getApiKey());
        returnMap.put(SIGN, sign);
        returnMap.put("packageValue", (String)returnMap.get("package"));
        WeChatPayResultBean bean = new WeChatPayResultBean();
        bean.setAppId((String)returnMap.get("appid"));
        bean.setPartnerId((String)returnMap.get("partnerid"));
        bean.setPrepayId((String)returnMap.get("prepayid"));
        bean.setPackageValue((String)returnMap.get("package"));
        bean.setNoncestr((String)returnMap.get("noncestr"));
        bean.setTimeStamp((String)returnMap.get("timestamp"));
        bean.setSign((String)returnMap.get(SIGN));
        return bean;
    }

    private Map<String, String> h5AndApppay(WeChatPayParamsBean params, String trade_type, String timestamp, String opernId) {
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        parameterMap.put("appid", this.account.getAppid());
        parameterMap.put("mch_id", this.account.getMchId());
        parameterMap.put("nonce_str", this.getRandomString(32));
        parameterMap.put("body", params.getBody());
        parameterMap.put(OUT_TRADE_NO, params.getOrderNo());
        parameterMap.put("fee_type", "CNY");
        parameterMap.put(TOTAL_FEE, params.getTotalAmount() + "");
        parameterMap.put("spbill_create_ip", params.getAddress());
        parameterMap.put("notify_url", params.getNotifyUrl());
        parameterMap.put("trade_type", trade_type);
        parameterMap.put("sign_type", "MD5");
        parameterMap.put("attach", params.getAttach());
        if (timestamp != null) {
            parameterMap.put("timeStamp", timestamp);
        }
        if (opernId != null) {
            parameterMap.put("openid", opernId);
        }
        String sign = this.createSign("UTF-8", parameterMap, this.account.getApiKey());
        parameterMap.put(SIGN, sign);
        String requestXML = WeChatPayUtil.getRequestXml(parameterMap);
        LoggerUtil.info(WeChatPayUtil.class, "\u7edf\u4e00\u4e0b\u5355\u5c01\u88c5\u53c2\u6570" + requestXML);
        String result = HttpUtil.doUrl("https://api.mch.weixin.qq.com/pay/unifiedorder", "POST", null, requestXML);
        SortedMap<String, String> map = null;
        try {
            map = this.xmlToMap(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String return_code = (String)map.get(RETURN_CODE);
        if (!return_code.equals("SUCCESS")) {
            LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u652f\u4ed8\u72b6\u6001\u7801\u5f02\u5e38:" + result);
            throw new RuntimeException("\u5fae\u4fe1\u652f\u4ed8\u72b6\u6001\u7801\u5f02\u5e38:" + result);
        }
        String result_code = (String)map.get(RESULT_CODE);
        if (!result_code.equals("SUCCESS")) {
            LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u8fd4\u56de\u652f\u4ed8\u5931\u8d25:", result);
            throw new RuntimeException("\u5fae\u4fe1\u8fd4\u56de\u652f\u4ed8\u5931\u8d25:" + result);
        }
        if (timestamp != null) {
            map.put("timeStamp", timestamp);
        }
        return map;
    }

    public WeChatPayToUserResultBean payToUser(WeChatPayToUserParamBean param, InputStream certInput) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("appid", this.account.getAppid());
        parameters.put("mch_id", this.account.getMchId());
        parameters.put("partner_trade_no", param.getOrderNo());
        parameters.put("nonce_str", this.getRandomString(32));
        parameters.put("openId", param.getOpenId());
        if (param.isCheckName()) {
            parameters.put("checkName", "FORCE_CHECK");
            parameters.put("re_user_name", param.getRealName());
        } else {
            parameters.put("checkName", "NO_CHECK");
        }
        parameters.put("amount", param.getAmount() + "");
        parameters.put("spbill_create_ip", param.getIpAddress());
        parameters.put("desc", param.getBody());
        String sign = this.createSign(parameters, this.account.getApiKey());
        parameters.put(SIGN, sign);
        String requestXML = WeChatPayUtil.getRequestXml(parameters);
        LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u7528\u6237\u96f6\u94b1\uff0c\u5c01\u88c5\u53c2\u6570:" + requestXML);
        String result = this.doHttps("https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers", requestXML, certInput);
        LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u7528\u6237\u96f6\u94b1\uff0c\u54cd\u5e94\u7ed3\u679c:" + result);
        WeChatPayToUserResultBean parseBean = JsonUtil.mapToBean(XmlUtil.xmlToMap(result), WeChatPayToUserResultBean.class);
        if (!StringUtil.isEmpty(parseBean.getReturn_code()) && !parseBean.getReturn_code().equals("SUCCESS")) {
            throw new RuntimeException("\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u7528\u6237\u96f6\u94b1\u8bf7\u6c42\u5931\u8d25:" + result);
        }
        if (!(StringUtil.isEmpty(parseBean.getResult_code()) || parseBean.getResult_code().equals("SUCCESS") || StringUtil.isEmpty(parseBean.getErr_code()) || parseBean.getErr_code().equals("SYSTEMERROR"))) {
            throw new RuntimeException("\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u7528\u6237\u96f6\u94b1\u8bf7\u6c42\u5931\u8d25:" + result);
        }
        return parseBean;
    }

    public WeChatPayToBankResultBean payToBank(WeChatPayToBankParamBean param, InputStream certInput) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("mch_id", this.account.getMchId());
        parameters.put("partner_trade_no", param.getOrderNo());
        parameters.put("nonce_str", this.getRandomString(32));
        parameters.put("enc_bank_no", param.getBankCardNo());
        parameters.put("enc_true_name", param.getRealName());
        parameters.put("bank_code", param.getBankCode());
        parameters.put("amount", param.getAmount() + "");
        String sign = this.createSign(parameters, this.account.getApiKey());
        parameters.put(SIGN, sign);
        String requestXML = WeChatPayUtil.getRequestXml(parameters);
        LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u94f6\u884c\u5361\uff0c\u5c01\u88c5\u53c2\u6570:" + requestXML);
        String result = this.doHttps("https://api.mch.weixin.qq.com/mmpaysptrans/pay_bank", requestXML, certInput);
        LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u94f6\u884c\u5361\uff0c\u54cd\u5e94\u7ed3\u679c:" + result);
        WeChatPayToBankResultBean parseBean = JsonUtil.mapToBean(XmlUtil.xmlToMap(result), WeChatPayToBankResultBean.class);
        if (!StringUtil.isEmpty(parseBean.getReturn_code()) && !parseBean.getReturn_code().equals("SUCCESS")) {
            throw new RuntimeException("\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u94f6\u884c\u5361\u8bf7\u6c42\u5931\u8d25:" + result);
        }
        if (!(StringUtil.isEmpty(parseBean.getResult_code()) || parseBean.getResult_code().equals("SUCCESS") || StringUtil.isEmpty(parseBean.getErr_code()) || parseBean.getErr_code().equals("SYSTEMERROR"))) {
            throw new RuntimeException("\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u94f6\u884c\u5361\u8bf7\u6c42\u5931\u8d25:" + result);
        }
        return parseBean;
    }

    public void queryPayToBank(String orderNo, InputStream certInput) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("mch_id", this.account.getMchId());
        parameters.put("partner_trade_no", orderNo);
        parameters.put("nonce_str", this.getRandomString(32));
        String sign = this.createSign(parameters, this.account.getApiKey());
        parameters.put(SIGN, sign);
        String requestXML = WeChatPayUtil.getRequestXml(parameters);
        LoggerUtil.info(WeChatPayUtil.class, "\u67e5\u8be2\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u94f6\u884c\u5361\uff0c\u5c01\u88c5\u53c2\u6570:" + requestXML);
        String result = this.doHttps("https://api.mch.weixin.qq.com/mmpaysptrans/query_bank", requestXML, certInput);
        LoggerUtil.info(WeChatPayUtil.class, "\u67e5\u8be2\u5fae\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u94f6\u884c\u5361\uff0c\u54cd\u5e94\u7ed3\u679c:" + result);
    }

    public int queryPayToUser(String orderNo, InputStream certInput) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("mch_id", this.account.getMchId());
        parameters.put("appid", this.account.getAppid());
        parameters.put("partner_trade_no", orderNo);
        parameters.put("nonce_str", this.getRandomString(32));
        String sign = this.createSign(parameters, this.account.getApiKey());
        parameters.put(SIGN, sign);
        String requestXML = WeChatPayUtil.getRequestXml(parameters);
        LoggerUtil.info(WeChatPayUtil.class, "\u67e5\u8be2\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u7528\u6237\u96f6\u94b1\uff0c\u5c01\u88c5\u53c2\u6570:" + requestXML);
        String result = this.doHttps("https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo", requestXML, certInput);
        LoggerUtil.info(WeChatPayUtil.class, "\u67e5\u8be2\u5fae\u5fae\u4fe1\u4f01\u4e1a\u4ed8\u6b3e\u81f3\u7528\u6237\u96f6\u94b1\uff0c\u54cd\u5e94\u7ed3\u679c:" + result);
        Map<String, Object> map = JsonUtil.jsonToMap(result);
        if (!map.get(RETURN_CODE).equals("SUCCESS")) {
            throw new RuntimeException("\u67e5\u8be2\u4ed8\u6b3e\u5230\u7528\u6237\u8d26\u6237\u8ba2\u5355\u5931\u8d25:" + result);
        }
        if (!map.get(RESULT_CODE).equals("SUCCESS")) {
            throw new RuntimeException("\u67e5\u8be2\u4ed8\u6b3e\u5230\u7528\u6237\u8d26\u6237\u8ba2\u5355\u5931\u8d25:" + result);
        }
        String status = map.get("status").toString();
        if (status.equalsIgnoreCase("SUCCESS")) {
            return 1;
        }
        if (status.equalsIgnoreCase("FAILED")) {
            return -1;
        }
        if (status.equalsIgnoreCase("PROCESSING")) {
            return 0;
        }
        return 0;
    }

    public WeChatPayStatus query(String orderNo, String weChatTradeNo) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("mch_id", this.account.getMchId());
        parameters.put("appid", this.account.getAppid());
        if (!StringUtil.isEmpty(orderNo)) {
            parameters.put(OUT_TRADE_NO, orderNo);
        } else if (!StringUtil.isEmpty(weChatTradeNo)) {
            parameters.put("transaction_id", weChatTradeNo);
        }
        parameters.put("nonce_str", this.getRandomString(32));
        String sign = this.createSign(parameters, this.account.getApiKey());
        parameters.put(SIGN, sign);
        String requestXML = WeChatPayUtil.getRequestXml(parameters);
        LoggerUtil.info(WeChatPayUtil.class, "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\uff0c\u5c01\u88c5\u53c2\u6570:" + requestXML);
        String result = HttpUtil.doUrl("https://api.mch.weixin.qq.com/pay/orderquery", "POST", null, requestXML);
        Map<String, Object> map = XmlUtil.xmlToMap(result);
        String return_code = map.get(RETURN_CODE).toString();
        if (!return_code.equals("SUCCESS")) {
            LoggerUtil.info(WeChatPayUtil.class, "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u72b6\u6001\u7801\u5f02\u5e38:" + result);
            throw new RuntimeException("\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u72b6\u6001\u7801\u5f02\u5e38:" + result);
        }
        String result_code = map.get(RESULT_CODE).toString();
        if (!result_code.equals("SUCCESS")) {
            LoggerUtil.info(WeChatPayUtil.class, "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u5931\u8d25:", result);
            throw new RuntimeException("\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u5931\u8d25:" + result);
        }
        String trade_state = map.get("trade_state").toString();
        return WeChatPayStatus.parse(trade_state);
    }

    private String getRandomString(int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(RANDOMSTR.length());
            sb.append(RANDOMSTR.charAt(number));
        }
        return sb.toString();
    }

    private SortedMap<String, String> xmlToMap(String strxml) throws IOException, JDOMException {
        if (null == (strxml = strxml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")) || "".equals(strxml)) {
            return null;
        }
        TreeMap<String, String> m = new TreeMap<String, String>();
        ByteArrayInputStream in = new ByteArrayInputStream(strxml.getBytes("UTF-8"));
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)in);
        Element root = doc.getRootElement();
        for (Element e : root.getChildren()) {
            String k = e.getName();
            String v = "";
            List children = e.getChildren();
            v = children.isEmpty() ? e.getTextNormalize() : this.getChildrenText(children);
            m.put(k, v);
        }
        ((InputStream)in).close();
        return m;
    }

    private String getChildrenText(List children) {
        StringBuffer sb = new StringBuffer();
        if (!children.isEmpty()) {
            for (Element e : children) {
                String name = e.getName();
                String value = e.getTextNormalize();
                List list = e.getChildren();
                sb.append("<" + name + ">");
                if (!list.isEmpty()) {
                    sb.append(this.getChildrenText(list));
                }
                sb.append(value);
                sb.append("</" + name + ">");
            }
        }
        return sb.toString();
    }

    public String createSign(SortedMap<String, String> parameters, String apiKey) {
        return this.createSign("UTF-8", parameters, apiKey);
    }

    public String createSign(String characterEncoding, SortedMap<String, String> parameters, String apiKey) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = parameters.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || SIGN.equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + apiKey);
        String sign = null;
        try {
            sign = StringUtil.toMD5(sb.toString(), characterEncoding).toUpperCase();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sign;
    }

    public WeChatRefundResultBean refund(String out_trade_no, String out_refund_no, int total_fee, int refund_fee, InputStream certInput) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("appid", this.account.getAppid());
        m.put("mch_id", this.account.getMchId());
        m.put("nonce_str", StringUtil.getRandomString(32));
        m.put(OUT_TRADE_NO, out_trade_no);
        m.put("out_refund_no", out_refund_no);
        m.put(TOTAL_FEE, total_fee + "");
        m.put("refund_fee", refund_fee + "");
        m.put("op_user_id", this.account.getMchId());
        String sign = this.createSign(m, this.account.getApiKey());
        m.put(SIGN, sign);
        LoggerUtil.info(WeChatPayUtil.class, "\u8bf7\u6c42\u5fae\u4fe1\u9000\u6b3e\u65f6\u7684\u53c2\u6570=" + m);
        String outputStr = WeChatPayUtil.getRequestXml(m);
        String result = this.doHttps("https://api.mch.weixin.qq.com/secapi/pay/refund", outputStr, certInput);
        LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u9000\u6b3e\u8fd4\u56de\u5185\u5bb9=" + result);
        Map<String, Object> map = XmlUtil.xmlToMap(result);
        if (map.containsKey(RETURN_CODE) && map.get(RETURN_CODE).equals("SUCCESS")) {
            if (!map.containsKey("err_code")) {
                return JsonUtil.mapToBean(map, WeChatRefundResultBean.class);
            }
            if (map.containsKey("err_code_des")) {
                throw new RuntimeException(map.get("err_code_des").toString());
            }
        }
        throw new RuntimeException("\u672a\u77e5\u5f02\u5e38\uff1a" + result);
    }

    public WeChatRefundResultBean parseRefundCallback(String notifyData) {
        Map<String, Object> map = XmlUtil.xmlToMap(notifyData);
        if (map.containsKey("req_info")) {
            String info = map.get("req_info").toString();
            String md5 = StringUtil.toMD5(this.account.getApiKey()).toLowerCase();
            String result = StringUtil.AESDecode(info, md5);
            Map<String, Object> parse = XmlUtil.xmlToMap(result);
            return JsonUtil.mapToBean(parse, WeChatRefundResultBean.class);
        }
        LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570req_info\uff0c\u53c2\u6570\u4fe1\u606f\uff1a" + notifyData);
        throw new RuntimeException("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570req_info\uff0c\u53c2\u6570\u4fe1\u606f\uff1a" + notifyData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doHttps(String wechatUrl, String outputStr, InputStream certInput) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            StringBuilder res = new StringBuilder("");
            try {
                keyStore.load(certInput, this.account.getMchId().toCharArray());
            }
            finally {
                try {
                    certInput.close();
                }
                catch (Exception exception) {}
            }
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, this.account.getMchId().toCharArray()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();){
                HttpPost httpost = new HttpPost(wechatUrl);
                httpost.addHeader("Connection", "keep-alive");
                httpost.addHeader("Accept", "*/*");
                httpost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                httpost.addHeader("Host", "api.mch.weixin.qq.com");
                httpost.addHeader("X-Requested-With", "XMLHttpRequest");
                httpost.addHeader("Cache-Control", "max-age=0");
                httpost.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0) ");
                StringEntity entity2 = new StringEntity(outputStr, Consts.UTF_8);
                httpost.setEntity((HttpEntity)entity2);
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpost);){
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(entity.getContent()));
                        String text = "";
                        res.append(text);
                        while ((text = bufferedReader.readLine()) != null) {
                            res.append(text);
                        }
                    }
                    EntityUtils.consume((HttpEntity)entity);
                }
            }
            return res.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getRequestXml(SortedMap<String, String> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<xml>");
        Set<Map.Entry<String, String>> es = parameters.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("attach".equalsIgnoreCase(key) || "body".equalsIgnoreCase(key) || SIGN.equalsIgnoreCase(key)) {
                sb.append("<" + key + "><![CDATA[" + value + "]]></" + key + ">");
                continue;
            }
            sb.append("<" + key + ">" + value + "</" + key + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public WeChatPayCallBackParseBean getCallBackData(String callBackData) {
        try {
            return this.getCallBackData(this.xmlToMap(callBackData));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WeChatPayCallBackParseBean getCallBackData(Map<String, String> map) {
        String charset = "utf-8";
        String signFromAPIResponse = map.get(SIGN);
        if (signFromAPIResponse == null || signFromAPIResponse.equals("")) {
            LoggerUtil.info(WeChatPayUtil.class, "\u672a\u53d1\u73b0\u56de\u8c03\u6570\u636e\u4e2d\u7684\u7b7e\u540d");
            throw new RuntimeException("\u672a\u53d1\u73b0\u56de\u8c03\u6570\u636e\u4e2d\u7684\u7b7e\u540d");
        }
        LoggerUtil.info(WeChatPayUtil.class, "\u670d\u52a1\u5668\u56de\u5305\u91cc\u9762\u7684\u7b7e\u540d\u662f:" + signFromAPIResponse);
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        for (String parameter : map.keySet()) {
            String parameterValue = map.get(parameter);
            String v = "";
            if (null != parameterValue) {
                v = parameterValue.trim();
            }
            packageParams.put(parameter, v);
        }
        StringBuffer sb = new StringBuffer();
        Set es = packageParams.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (SIGN.equals(k) || null == v || "".equals(v)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + this.account.getApiKey());
        String resultSign = "";
        String tobesign = sb.toString();
        if (null == charset || "".equals(charset)) {
            try {
                resultSign = StringUtil.toMD5(tobesign, charset).toUpperCase();
            }
            catch (Exception e) {
                LoggerUtil.error(WeChatPayUtil.class, e);
                throw new RuntimeException(e);
            }
        }
        try {
            resultSign = StringUtil.toMD5(tobesign, charset).toUpperCase();
        }
        catch (Exception e) {
            LoggerUtil.error(WeChatPayUtil.class, e);
            throw new RuntimeException(e);
        }
        String tenpaySign = ((String)packageParams.get(SIGN)).toUpperCase();
        if (!tenpaySign.equals(resultSign)) {
            LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u8fd4\u56de\u7684\u7b7e\u540d\u4e0e\u672c\u673a\u751f\u6210\u7684\u4e0d\u4e00\u81f4");
            throw new RuntimeException("\u5fae\u4fe1\u8fd4\u56de\u7684\u7b7e\u540d\u4e0e\u672c\u673a\u751f\u6210\u7684\u4e0d\u4e00\u81f4");
        }
        LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u56de\u8c03\u8fd4\u56de\u4fe1\u606f:" + map);
        if (!map.get(RETURN_CODE).equals("SUCCESS")) {
            LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u56de\u8c03\u8fd4\u56de\u652f\u4ed8\u5931\u8d25,\u8fd4\u56de\u53c2\u6570\u4e3a:" + map);
            throw new RuntimeException("\u652f\u4ed8\u5931\u8d25");
        }
        if (!map.get(RESULT_CODE).equals("SUCCESS")) {
            LoggerUtil.info(WeChatPayUtil.class, "\u5fae\u4fe1\u56de\u8c03\u8fd4\u56de\u652f\u4ed8\u5931\u8d25,\u8fd4\u56de\u53c2\u6570\u4e3a:" + map);
            throw new RuntimeException("\u652f\u4ed8\u5931\u8d25");
        }
        String json = JsonUtil.beanToJson(map);
        return JsonUtil.jsonToBean(json, WeChatPayCallBackParseBean.class);
    }

    public String returnMessage() {
        return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
    }
}

