/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.wechat.pay;

import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.platform.wechat.base.WeChatPayAccount;
import cn.easyutil.util.platform.wechat.base.WeChatPayStatus;
import cn.easyutil.util.platform.wechat.base.WeChatPayType;
import cn.easyutil.util.platform.wechat.pay.WeChatPayUtil;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayCallBackParseBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayParamsBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayResultBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayToUserParamBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatPayToUserResultBean;
import cn.easyutil.util.platform.wechat.pay.bean.WeChatRefundResultBean;
import java.io.File;
import java.io.FileInputStream;

public class WeChatPayOperation {
    private WeChatPayAccount account;
    private WeChatPayUtil payOperation;
    String successMsg = "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
    private String certPath;

    public static WeChatPayOperation build(WeChatPayAccount account) {
        WeChatPayUtil wo;
        WeChatPayOperation operation = new WeChatPayOperation();
        operation.account = account;
        operation.payOperation = wo = new WeChatPayUtil(account);
        return operation;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public WeChatPayResultBean payOrder(WeChatPayType type, WeChatPayParamsBean params) {
        switch (type) {
            case thePublic: 
            case smallApp: {
                return this.payOperation.publicpay(params);
            }
            case h5: {
                return this.payOperation.h5pay(params);
            }
            case appp: {
                return this.payOperation.apppay(params);
            }
            case scann: {
                return this.payOperation.scannpay(params);
            }
        }
        return null;
    }

    public WeChatPayStatus queryOrder(String orderNo) {
        return this.payOperation.query(orderNo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WeChatPayToUserResultBean payToUser(WeChatPayToUserParamBean param) {
        if (StringUtil.isEmpty(this.certPath)) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u9000\u6b3e\u7b7e\u540d\u6587\u4ef6\u8def\u5f84");
        }
        try (FileInputStream certInput = new FileInputStream(new File(this.certPath));){
            WeChatPayToUserResultBean result;
            WeChatPayToUserResultBean weChatPayToUserResultBean = result = this.payOperation.payToUser(param, certInput);
            return weChatPayToUserResultBean;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int queryPayToUser(String orderNo) {
        if (StringUtil.isEmpty(this.certPath)) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u9000\u6b3e\u7b7e\u540d\u6587\u4ef6\u8def\u5f84");
        }
        try (FileInputStream certInput = new FileInputStream(new File(this.certPath));){
            int n = this.payOperation.queryPayToUser(orderNo, certInput);
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WeChatRefundResultBean refund(String outTradeNo, String outRefundNo, int totalFee, int refundFee) {
        if (StringUtil.isEmpty(this.certPath)) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u9000\u6b3e\u7b7e\u540d\u6587\u4ef6\u8def\u5f84");
        }
        try (FileInputStream certInput = new FileInputStream(new File(this.certPath));){
            WeChatRefundResultBean weChatRefundResultBean = this.payOperation.refund(outTradeNo, outRefundNo, totalFee, refundFee, certInput);
            return weChatRefundResultBean;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public WeChatRefundResultBean refundCallback(String notifyData) {
        return this.payOperation.parseRefundCallback(notifyData);
    }

    public WeChatPayCallBackParseBean payCallBack(String callBackData) {
        return this.payOperation.getCallBackData(callBackData);
    }

    public String returnSuccess() {
        return this.successMsg;
    }
}

