/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.jiguang;

import cn.easyutil.util.javaUtil.HttpUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JiguangPushUtil {
    private String appkey;
    private String masterSecret;
    private String authKey = "Authorization";
    private String baseUrl = "https://api.jpush.cn/v3/push";
    private List<String> tagList = new ArrayList<String>();
    private List<String> tagAndList = new ArrayList<String>();
    private List<String> tagNotList = new ArrayList<String>();
    private List<String> aliasList = new ArrayList<String>();
    private List<String> registrationIdsList = new ArrayList<String>();
    private Map<String, String> extras = new HashMap<String, String>();
    private int platformType = 0;

    public JiguangPushUtil(String appkey, String masterSecret) {
        this.appkey = appkey;
        this.masterSecret = masterSecret;
    }

    public static JiguangPushUtil build(String appkey, String masterSecret) {
        return new JiguangPushUtil(appkey, masterSecret);
    }

    public JiguangPushUtil setTags(String ... tags) {
        this.tagList.addAll(Arrays.asList(tags));
        return this;
    }

    public JiguangPushUtil setTagsAnd(String ... and) {
        this.tagAndList.addAll(Arrays.asList(and));
        return this;
    }

    public JiguangPushUtil setTagsNot(String ... not) {
        this.tagNotList.addAll(Arrays.asList(not));
        return this;
    }

    public JiguangPushUtil setAlias(String ... alias) {
        this.aliasList.addAll(Arrays.asList(alias));
        return this;
    }

    public JiguangPushUtil setRegistrationIds(String ... registrationIds) {
        if (registrationIds.length > 1000) {
            throw new RuntimeException("\u4e00\u6b21\u63a8\u9001\u7684\u76ee\u6807\u7528\u6237\u4e0d\u80fd\u8d85\u8fc71000\u4e2a");
        }
        this.registrationIdsList.addAll(Arrays.asList(registrationIds));
        return this;
    }

    public JiguangPushUtil setPlatform(Integer platformType) {
        if (platformType != null && platformType >= 0 && platformType <= 2) {
            this.platformType = platformType;
        }
        return this;
    }

    public JiguangPushUtil setCustomizeParam(String key, String val) {
        this.extras.put(key, val);
        return this;
    }

    public void push(String text, String ... registrationIds) {
        this.setRegistrationIds(registrationIds);
        this.push(text);
    }

    public void push(String text) {
        this.push(text, (String)null, (String)null);
    }

    public void push(String text, String title, String img) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, List<String>> audience = new HashMap<String, List<String>>();
        if (!this.tagList.isEmpty()) {
            audience.put("tag", this.tagList);
        }
        if (!this.tagAndList.isEmpty()) {
            audience.put("tag_and", this.tagAndList);
        }
        if (!this.tagNotList.isEmpty()) {
            audience.put("tag_not", this.tagNotList);
        }
        if (!this.aliasList.isEmpty()) {
            audience.put("alias", this.aliasList);
        }
        if (!this.registrationIdsList.isEmpty()) {
            audience.put("registration_id", this.registrationIdsList);
        }
        if (audience.isEmpty()) {
            throw new RuntimeException("\u63a5\u6536\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.platformType == 0) {
            param.put("platform", new String[]{"android", "ios"});
            param.put("notification", this.notificationAll(text, title, img));
        } else if (this.platformType == 1) {
            param.put("platform", new String[]{"android"});
            param.put("notification", this.notificationAndroid(text, title, img));
        } else if (this.platformType == 2) {
            param.put("platform", new String[]{"ios"});
            param.put("notification", this.notificationIos(text, title, img));
        }
        param.put("audience", audience);
        HttpUtil util = new HttpUtil();
        util.setRequestUrl(this.baseUrl);
        util.setRequestMethod("POST");
        util.setJsonRequestParam(param);
        util.setHeaders(this.authKey, "Basic " + StringUtil.base64Encode(this.appkey + ":" + this.masterSecret));
        try {
            util.doUrl();
        }
        catch (Exception e) {
            throw new RuntimeException("\u63a5\u6536\u8005\u8bbe\u7f6e\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728");
        }
    }

    private Map<String, Object> notificationAll(String text, String title, String img) {
        HashMap<String, Object> notification = new HashMap<String, Object>();
        notification.putAll(this.notificationAndroid(text, title, img));
        notification.putAll(this.notificationIos(text, title, img));
        return notification;
    }

    private Map<String, Object> notificationAndroid(String text, String title, String img) {
        if (StringUtil.isEmpty(text)) {
            throw new RuntimeException("\u63a8\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> android = new HashMap<String, Object>();
        android.put("alert", text);
        if (!StringUtil.isEmpty(title)) {
            android.put("title", title);
        }
        if (!StringUtil.isEmpty(img) && (img.endsWith(".jpg") || img.endsWith(".png"))) {
            android.put("style", 3);
            android.put("big_pic_path", img);
        }
        android.put("extras", this.extras);
        param.put("android", android);
        return param;
    }

    private Map<String, Object> notificationIos(String text, String title, String img) {
        if (StringUtil.isEmpty(text)) {
            throw new RuntimeException("\u63a8\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> ios = new HashMap<String, Object>();
        ios.put("alert", text);
        ios.put("extras", this.extras);
        param.put("ios", ios);
        return param;
    }

    public void updateAlias(String registrationId, String alias) {
        if (StringUtil.isEmpty(alias)) {
            throw new RuntimeException("\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(registrationId)) {
            throw new RuntimeException("registrationId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://device.jpush.cn/v3/devices/" + registrationId;
        HttpUtil http = new HttpUtil(url);
        http.setRequestMethod("POST");
        http.setHeaders(this.authKey, "Basic " + StringUtil.base64Encode(this.appkey + ":" + this.masterSecret));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("alias", alias);
        http.setJsonRequestParam(param);
        http.doUrl();
    }

    public List<String> getAliasUsers(String alias) {
        if (StringUtil.isEmpty(alias)) {
            throw new RuntimeException("\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://device.jpush.cn/v3/aliases/" + alias;
        HttpUtil http = new HttpUtil(url);
        http.setRequestMethod("GET");
        http.setHeaders(this.authKey, "Basic " + StringUtil.base64Encode(this.appkey + ":" + this.masterSecret));
        String result = http.doUrl();
        JSONArray array = JSONObject.parseObject((String)result).getJSONArray("registration_ids");
        return JsonUtil.jsonToList(JsonUtil.beanToJson(array), String.class);
    }

    public void addTags(String registrationId, String ... tags) {
        if (tags.length == 0) {
            throw new RuntimeException("\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://device.jpush.cn/v3/devices/" + registrationId;
        HttpUtil http = new HttpUtil(url);
        http.setRequestMethod("POST");
        http.setHeaders(this.authKey, "Basic " + StringUtil.base64Encode(this.appkey + ":" + this.masterSecret));
        HashMap param = new HashMap();
        HashMap<String, String[]> add = new HashMap<String, String[]>();
        add.put("add", tags);
        param.put("tags", add);
        http.setJsonRequestParam(param);
        http.doUrl();
    }

    public void deleteTags(String registrationId, String ... tags) {
        if (tags.length == 0) {
            throw new RuntimeException("\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://device.jpush.cn/v3/devices/" + registrationId;
        HttpUtil http = new HttpUtil(url);
        http.setRequestMethod("POST");
        http.setHeaders(this.authKey, "Basic " + StringUtil.base64Encode(this.appkey + ":" + this.masterSecret));
        HashMap param = new HashMap();
        HashMap<String, String[]> remove = new HashMap<String, String[]>();
        remove.put("remove", tags);
        param.put("tags", remove);
        http.setJsonRequestParam(param);
        http.doUrl();
    }

    public JiguangPushUser getJiguangUser(String registrationId) {
        String url = "https://device.jpush.cn/v3/devices/" + registrationId;
        HttpUtil http = new HttpUtil(url);
        http.setRequestMethod("GET");
        http.setHeaders(this.authKey, "Basic " + StringUtil.base64Encode(this.appkey + ":" + this.masterSecret));
        String result = http.doUrl();
        JSONObject obj = JSONObject.parseObject((String)result);
        JiguangPushUser user = new JiguangPushUser();
        user.setRegistrationId(registrationId);
        user.setAlias(obj.getString("alias"));
        user.setMobile(obj.getString("mobile"));
        JSONArray array = obj.getJSONArray("tags");
        user.setTags(JsonUtil.jsonToList(JsonUtil.beanToJson(array), String.class));
        return user;
    }

    public static void main(String[] args) {
    }

    class JiguangPushUser {
        private String registrationId;
        private List<String> tags;
        private String alias;
        private String mobile;

        JiguangPushUser() {
        }

        public String getRegistrationId() {
            return this.registrationId;
        }

        public void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getMobile() {
            return this.mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }
    }
}

