/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.jiguang;

import cn.easyutil.util.javaUtil.HttpUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.platform.jiguang.bean.JiguangIMUser;
import cn.easyutil.util.platform.jiguang.bean.JiguangQueryResult;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JiguangIMUtil {
    private String appkey;
    private String masterSecret;
    private String authKey = "Authorization";
    private String baseUrl = "https://api.im.jpush.cn";

    public JiguangIMUtil(String appkey, String masterSecret) {
        this.appkey = appkey;
        this.masterSecret = masterSecret;
    }

    public static JiguangIMUtil build(String appkey, String masterSecret) {
        return new JiguangIMUtil(appkey, masterSecret);
    }

    public String getAppkey() {
        return this.appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getMasterSecret() {
        return this.masterSecret;
    }

    public void setMasterSecret(String masterSecret) {
        this.masterSecret = masterSecret;
    }

    public void registUser(String username, String password) {
        this.registUser(username, password, null);
    }

    public void registUser(String username, String password, JiguangIMUser user) {
        if (StringUtil.isEmpty(username) || username.startsWith("0")) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u4e0d\u80fd\u4ee50\u5f00\u5934");
        }
        if (StringUtil.isEmpty(password)) {
            throw new RuntimeException("\u7528\u6237\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (user == null) {
            user = new JiguangIMUser();
        }
        HttpUtil util = this.getHttpUtil("/v1/users/");
        util.setRequestMethod("POST");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("username", username);
        param.put("password", password);
        param.putAll(this.parseUser(user));
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(param);
        util.setJsonRequestParam(list);
        util.doUrl();
    }

    public void registAdmin(String username, String password) {
        this.registAdmin(username, password, null);
    }

    public void registAdmin(String username, String password, JiguangIMUser user) {
        if (StringUtil.isEmpty(username) || username.startsWith("0")) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u4e0d\u80fd\u4ee50\u5f00\u5934");
        }
        if (StringUtil.isEmpty(password)) {
            throw new RuntimeException("\u7528\u6237\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (user == null) {
            user = new JiguangIMUser();
        }
        HttpUtil util = this.getHttpUtil("/v1/admins/");
        util.setRequestMethod("POST");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("username", username);
        param.put("password", password);
        param.putAll(this.parseUser(user));
        util.setJsonRequestParam(param);
        util.doUrl();
    }

    public JiguangQueryResult getAdminsList(int currentPage, int showCount) {
        HttpUtil util = this.getHttpUtil("/v1/admins?start=" + currentPage * showCount + "&count=" + showCount);
        util.setRequestMethod("GET");
        String result = util.doUrl();
        return JsonUtil.jsonToBean(result, JiguangQueryResult.class);
    }

    public JiguangIMUser getUserInfo(String username) {
        if (StringUtil.isEmpty(username) || username.startsWith("0")) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u4e0d\u80fd\u4ee50\u5f00\u5934");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username);
        util.setRequestMethod("GET");
        String result = util.doUrl();
        JiguangIMUser user = JsonUtil.jsonToBean(result, JiguangIMUser.class);
        Map<String, Object> map = JsonUtil.jsonToMap(result);
        if (map.get("avatar") != null) {
            user.setHeaderImg(map.get("avatar").toString());
        }
        if (map.get("gender") != null) {
            Integer gender = Integer.valueOf(map.get("gender").toString());
            gender = gender == 1 ? 1 : (gender == 2 ? 0 : -1);
            user.setSex(gender);
        }
        return user;
    }

    public void updateUserInfo(String username, JiguangIMUser user) {
        if (StringUtil.isEmpty(username) || username.startsWith("0")) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u4e0d\u80fd\u4ee50\u5f00\u5934");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username);
        util.setRequestMethod("PUT");
        util.setJsonRequestParam(this.parseUser(user));
        util.doUrl();
    }

    public boolean getUserOnlineStatus(String username) {
        if (StringUtil.isEmpty(username)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/userstat");
        try {
            String result = util.setRequestMethod("GET").doUrl();
            Map<String, Object> map = JsonUtil.jsonToMap(result);
            return Boolean.valueOf(map.get("online").toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<UserOnlineStatus> getUserOnlineStatus(Collection<String> usernames) {
        if (usernames == null || usernames.size() == 0) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v2/users/statuser");
        util.setRequestMethod("POST");
        util.setJsonRequestParam(usernames);
        String result = util.doUrl();
        JSONArray array = JSONArray.parseArray((String)result);
        ArrayList<UserOnlineStatus> list = new ArrayList<UserOnlineStatus>();
        for (Object object : array) {
            if (!(object instanceof JSONObject)) continue;
            JSONObject obj = (JSONObject)object;
            JSONArray devices = obj.getJSONArray("devices");
            UserOnlineStatus status = new UserOnlineStatus();
            if (devices != null && devices.size() > 0) {
                Map dev = (Map)devices.getObject(0, Map.class);
                if (dev != null && dev.get("online") != null) {
                    status.setOnline(Boolean.valueOf(dev.get("online").toString()));
                } else {
                    status.setOnline(false);
                }
            }
            if (obj.getString("username") != null) {
                status.setUsername(obj.getString("username"));
            }
            list.add(status);
        }
        return list;
    }

    public void updateUserPassword(String username, String password) {
        if (StringUtil.isEmpty(username)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(password)) {
            throw new RuntimeException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/password");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("new_password", password);
        util.setJsonRequestParam(param);
        util.setRequestMethod("PUT");
        try {
            util.doUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteUsers(String ... usernames) {
        if (usernames.length == 0) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/");
        util.setRequestMethod("DELETE");
        util.setJsonRequestParam(Arrays.asList(usernames));
        util.doUrl();
    }

    public void setBlackList(String username, String ... blackUsers) {
        if (StringUtil.isEmpty(username) || blackUsers.length == 0) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/blacklist");
        util.setRequestMethod("PUT");
        util.setJsonRequestParam(Arrays.asList(blackUsers));
        util.doUrl();
    }

    public void deleteBlackList(String username, String ... blackUsers) {
        if (StringUtil.isEmpty(username) || blackUsers.length == 0) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/blacklist");
        util.setRequestMethod("DELETE");
        util.setJsonRequestParam(Arrays.asList(blackUsers));
        util.doUrl();
    }

    public List<JiguangIMUser> getBlackList(String username) {
        if (StringUtil.isEmpty(username)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/blacklist");
        util.setRequestMethod("GET");
        String result = util.doUrl();
        return JsonUtil.jsonToList(result, JiguangIMUser.class);
    }

    public JiguangQueryResult getUserList(int currentPage, int showCount) {
        HttpUtil util = this.getHttpUtil("/v1/users/?start=" + currentPage * showCount + "&count=" + showCount);
        util.setRequestMethod("GET");
        return JsonUtil.jsonToBean(util.doUrl(), JiguangQueryResult.class);
    }

    public void setUserNodisturb(int type, String username, String ... singleUsers) {
        if (StringUtil.isEmpty(username)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/nodisturb");
        util.setRequestMethod("POST");
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        if (type == 0 || type == 1) {
            param.put("global", Integer.valueOf(type));
            util.setJsonRequestParam(param);
            util.doUrl();
            return;
        }
        if (type == 2) {
            HashMap<String, List<String>> single = new HashMap<String, List<String>>();
            single.put("add", Arrays.asList(singleUsers));
            param.put("single", single);
            util.setJsonRequestParam(param);
            util.doUrl();
            return;
        }
        if (type == 3) {
            HashMap<String, List<String>> single = new HashMap<String, List<String>>();
            single.put("remove", Arrays.asList(singleUsers));
            param.put("single", single);
            util.setJsonRequestParam(param);
            util.doUrl();
            return;
        }
        if (type == 4) {
            HashMap<String, List<String>> group = new HashMap<String, List<String>>();
            group.put("add", Arrays.asList(singleUsers));
            param.put("group", group);
            util.setJsonRequestParam(param);
            util.doUrl();
            return;
        }
        if (type == 5) {
            HashMap<String, List<String>> group = new HashMap<String, List<String>>();
            group.put("remove", Arrays.asList(singleUsers));
            param.put("group", group);
            util.setJsonRequestParam(param);
            util.doUrl();
            return;
        }
    }

    public String sendMsg(int type, String fromUsername, String toUsername, String text, String img) {
        if (StringUtil.isEmpty(fromUsername) || StringUtil.isEmpty(toUsername)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(text) && StringUtil.isEmpty(img)) {
            throw new RuntimeException("\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/messages");
        util.setRequestMethod("POST");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("version", 1);
        param.put("target_id", toUsername);
        param.put("from_id", fromUsername);
        HashMap<String, String> msgBody = new HashMap<String, String>();
        if (img != null) {
            param.put("msg_type", "image");
            msgBody.put("media_id", img);
            msgBody.put("media_crc32", "");
            msgBody.put("width", "");
            msgBody.put("height", "");
            msgBody.put("fsize", "");
            msgBody.put("format", "JPG");
        } else {
            param.put("msg_type", "text");
            msgBody.put("text", text);
        }
        param.put("msg_body", msgBody);
        switch (type) {
            case 0: {
                param.put("from_type", "user");
                param.put("target_type", "single");
                break;
            }
            case 1: {
                param.put("from_type", "user");
                param.put("target_type", "group");
                break;
            }
            case 2: {
                param.put("from_type", "user");
                param.put("target_type", "chatroom");
                break;
            }
            case 3: {
                param.put("from_type", "admin");
                param.put("target_type", "single");
                break;
            }
            case 4: {
                param.put("from_type", "admin");
                param.put("target_type", "group");
                break;
            }
            case 5: {
                param.put("from_type", "admin");
                param.put("target_type", "chatroom");
                break;
            }
            default: {
                throw new RuntimeException("\u7c7b\u578b\u9519\u8bef");
            }
        }
        String result = util.setJsonRequestParam(param).doUrl();
        return JsonUtil.jsonToMap(result).get("msg_id").toString();
    }

    public void cancelMsg(String username, String msgId) {
        if (StringUtil.isEmpty(username)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(msgId)) {
            throw new RuntimeException("\u6d88\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/messages/" + username + "/" + msgId + "/retract");
        util.setRequestMethod("POST");
        try {
            util.doUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFriends(String username, String ... friendsUsers) {
        if (StringUtil.isEmpty(username) || friendsUsers.length == 0) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/friends");
        util.setRequestMethod("POST");
        util.setJsonRequestParam(Arrays.asList(friendsUsers));
        util.doUrl();
    }

    public void deleteFriends(String username, String ... friendsUsers) {
        if (StringUtil.isEmpty(username) || friendsUsers.length == 0) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/friends");
        util.setRequestMethod("DELETE");
        util.setJsonRequestParam(Arrays.asList(friendsUsers));
        util.doUrl();
    }

    public void setFriendsAlias(String username, String friendUsername, String aliasName) {
        if (StringUtil.isEmpty(username) || StringUtil.isEmpty(friendUsername) || StringUtil.isEmpty(aliasName)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/friends");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("note_name", aliasName);
        param.put("username", friendUsername);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(param);
        util.setJsonRequestParam(list);
        util.setRequestMethod("PUT");
        try {
            util.doUrl();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5148\u6210\u4e3a\u597d\u53cb\u624d\u80fd\u4fee\u6539\u5907\u6ce8");
        }
    }

    public List<JiguangIMUser> getFriendsList(String username) {
        if (StringUtil.isEmpty(username)) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil util = this.getHttpUtil("/v1/users/" + username + "/friends");
        String result = util.setRequestMethod("GET").doUrl();
        return JsonUtil.jsonToList(result, JiguangIMUser.class);
    }

    public static void main(String[] args) {
        JiguangIMUtil push = JiguangIMUtil.build("49470b0d6ac0f900bf32352d", "7cc220ed09985564507605ef");
        push.updateUserPassword("6727", "e10adc3949ba59abbe56e057f20f883e");
    }

    private Map<String, String> parseUser(JiguangIMUser user) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (user == null) {
            return param;
        }
        if (!StringUtil.isEmpty(user.getNickname())) {
            param.put("nickname", user.getNickname());
        }
        if (!StringUtil.isEmpty(user.getAddress())) {
            param.put("address", user.getAddress());
        }
        if (!StringUtil.isEmpty(user.getBirthday())) {
            param.put("birthday", user.getBirthday());
        }
        if (!StringUtil.isEmpty(user.getHeaderImg())) {
            param.put("avatar", user.getHeaderImg());
        }
        if (!StringUtil.isEmpty(user.getSex())) {
            Integer sex = user.getSex();
            sex = sex == 0 ? 2 : (sex == 1 ? 1 : 0);
            param.put("gender", sex.toString());
        }
        if (!StringUtil.isEmpty(user.getSignature())) {
            param.put("signature", user.getSignature());
        }
        return param;
    }

    private HttpUtil getHttpUtil(String url) {
        HttpUtil util = new HttpUtil();
        util.setRequestUrl(this.baseUrl + url);
        util.setHeaders(this.authKey, "Basic " + StringUtil.base64Encode(this.appkey + ":" + this.masterSecret));
        util.setHeaders("Content-Type", "application/json");
        return util;
    }

    class UserOnlineStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String username;
        private boolean online;

        UserOnlineStatus() {
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public boolean isOnline() {
            return this.online;
        }

        public void setOnline(boolean online) {
            this.online = online;
        }
    }
}

