/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.alibaba.alipay;

import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.platform.alibaba.alipay.bean.AliPayBizParamBean;
import cn.easyutil.util.platform.alibaba.alipay.bean.AliPayResultBean;
import cn.easyutil.util.platform.alibaba.alipay.bean.AliPayToAliParamBean;
import cn.easyutil.util.platform.alibaba.alipay.bean.AliRefundParseBean;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayFundTransOrderQueryRequest;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayFundTransOrderQueryResponse;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;

public class AliPayUtil {
    private String appId;
    private String privateKey;
    private String publicKey;
    private String callBackPublicKey;
    private String charset = "UTF-8";
    private String signType = "RSA2";

    public AliPayUtil() {
    }

    public AliPayUtil(String appId, String privateKey, String publicKey) {
        this.appId = appId;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public AliPayUtil(String appId, String privateKey, String publicKey, String callBackPublicKey) {
        this.appId = appId;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.callBackPublicKey = callBackPublicKey;
    }

    public String getCallBackPublicKey() {
        return this.callBackPublicKey;
    }

    public void setCallBackPublicKey(String callBackPublicKey) {
        this.callBackPublicKey = callBackPublicKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String h5pay(AliPayBizParamBean biz) {
        return this.h5pay(this.appId, this.privateKey, this.publicKey, biz);
    }

    public String h5pay(String appId, String privateKey, String publicKey, AliPayBizParamBean biz) {
        if (StringUtil.isEmpty(appId) || StringUtil.isEmpty(privateKey) || StringUtil.isEmpty(publicKey)) {
            throw new RuntimeException("\u652f\u4ed8\u8d26\u6237\u4fe1\u606f\u7f3a\u5931");
        }
        if (!biz.check()) {
            throw new RuntimeException("\u652f\u4ed8\u53c2\u6570\u7f3a\u5931");
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, privateKey, "json", this.charset, publicKey, this.signType);
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setReturnUrl(biz.getReturnUrl());
        alipayRequest.setNotifyUrl(biz.getNotifyUrl());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("out_trade_no", biz.getOutTradeNo());
        param.put("total_amount", biz.getTotalAmount() + "");
        param.put("subject", biz.getSubject());
        if (!StringUtil.isEmpty(biz.getBody())) {
            param.put("body", biz.getBody());
        }
        if (!StringUtil.isEmpty(biz.getPassbackParams())) {
            param.put("passback_params", biz.getPassbackParams());
        }
        param.put("product_code", "QUICK_WAP_PAY");
        alipayRequest.setBizContent(JsonUtil.beanToJson(param));
        String form = "";
        try {
            LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9dH5\u652f\u4ed8\u53c2\u6570:" + JsonUtil.beanToJson(alipayRequest));
            form = ((AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest)).getBody();
            LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9dH5\u652f\u4ed8\u8fd4\u56de\u7ed3\u679c:" + form);
            return form;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String query(String out_trade_no, String trade_no) {
        return this.query(this.appId, this.privateKey, this.publicKey, out_trade_no, trade_no);
    }

    public String query(String appId, String privateKey, String publicKey, String out_trade_no, String trade_no) {
        if (StringUtil.isEmpty(appId) || StringUtil.isEmpty(privateKey) || StringUtil.isEmpty(publicKey)) {
            throw new RuntimeException("\u652f\u4ed8\u8d26\u6237\u4fe1\u606f\u7f3a\u5931");
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, privateKey, "json", this.charset, publicKey, this.signType);
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        HashMap<String, String> param = new HashMap<String, String>();
        if (!StringUtil.isEmpty(out_trade_no)) {
            param.put("out_trade_no", out_trade_no);
        }
        if (!StringUtil.isEmpty(trade_no)) {
            param.put("trade_no", out_trade_no);
        }
        request.setBizContent(JsonUtil.beanToJson(param));
        try {
            LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f,\u53c2\u6570:" + JsonUtil.beanToJson(request));
            AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f,\u8fd4\u56de\u7ed3\u679c:" + response.getBody());
            return response.getBody();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AliPayResultBean getCallBackData(Map<String, String> param, String publicKey) {
        param.remove("sign_type");
        if (StringUtil.isEmpty(publicKey)) {
            throw new RuntimeException("\u652f\u4ed8\u8d26\u6237\u4fe1\u606f\u7f3a\u5931");
        }
        try {
            boolean signVerified = AlipaySignature.rsaCheckV1(param, (String)publicKey, (String)this.charset, (String)this.signType);
            if (!signVerified) {
                LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u9a8c\u7b7e\u53c2\u6570:" + param);
                LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u9a8c\u7b7e\u516c\u94a5:" + publicKey);
                LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u9a8c\u7b7e\u5b57\u7b26\u96c6:" + this.charset);
                LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u9a8c\u7b7e\u52a0\u5bc6\u65b9\u6cd5:" + this.signType);
                throw new RuntimeException("\u652f\u4ed8\u5b9d\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AliPayResultBean result = new AliPayResultBean();
        String appId = param.get("app_id");
        result.setAppId(appId);
        String notifyTime = param.get("notify_time");
        result.setNotifyTime(notifyTime);
        String gmtCreate = param.get("gmt_create");
        result.setGmtCreate(gmtCreate);
        String gmtPayment = param.get("gmt_payment");
        result.setGmtPayment(gmtPayment);
        String gmtRefund = param.get("gmt_refund");
        result.setGmtRefund(gmtRefund);
        String gmtClose = param.get("gmt_close");
        result.setGmtClose(gmtClose);
        String tradeNo = param.get("trade_no");
        result.setTradeNo(tradeNo);
        String outTradeNo = param.get("out_trade_no");
        result.setOutTradeNo(outTradeNo);
        String outBizNo = param.get("out_biz_no");
        result.setOutBizNo(outBizNo);
        String buyerLogonId = param.get("buyer_logon_id");
        result.setBuyerLogonId(buyerLogonId);
        String sellerId = param.get("seller_id");
        result.setSellerId(sellerId);
        String sellerEmail = param.get("seller_email");
        result.setSellerEmail(sellerEmail);
        String totalAmount = param.get("total_amount");
        result.setTotalAmount(totalAmount);
        String receiptAmount = param.get("receipt_amount");
        result.setReceiptAmount(receiptAmount);
        String invoiceAmount = param.get("invoice_amount");
        result.setInvoiceAmount(invoiceAmount);
        String buyerPayAmount = param.get("buyer_pay_amount");
        result.setBuyerPayAmount(buyerPayAmount);
        String tradeStatus = param.get("trade_status");
        result.setTradeStatus(tradeStatus);
        String passback_params = param.get("passback_params");
        if (!StringUtil.isEmpty(passback_params)) {
            result.setPassbackParams(StringUtil.UrlDecode(passback_params));
        }
        LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u5c01\u88c5:" + JsonUtil.beanToJson(result));
        return result;
    }

    public AliPayResultBean getCallBackData(HttpServletRequest request) {
        return this.getCallBackData(request, this.getCallBackPublicKey() == null ? this.getPublicKey() : this.getCallBackPublicKey());
    }

    public AliPayResultBean getCallBackData(HttpServletRequest request, String callBackPublicKey) {
        HashMap<String, String> param = new HashMap<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            param.put(name, request.getParameter(name));
        }
        return this.getCallBackData(param, callBackPublicKey);
    }

    public AliRefundParseBean refund(String appId, String privateKey, String publicKey, String out_trade_no, String trade_no, String out_biz_no, double refund_amount) {
        if (StringUtil.isEmpty(appId) || StringUtil.isEmpty(privateKey) || StringUtil.isEmpty(publicKey)) {
            throw new RuntimeException("\u652f\u4ed8\u8d26\u6237\u4fe1\u606f\u7f3a\u5931");
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, privateKey, "json", this.charset, publicKey, this.signType);
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("out_trade_no", out_trade_no);
        param.put("trade_no", trade_no);
        param.put("out_request_no", out_biz_no);
        param.put("refund_amount", refund_amount + "");
        LoggerUtil.info(this.getClass(), "\u5c01\u88c5\u652f\u4ed8\u5b9d\u9000\u6b3e\u53c2\u6570:" + JsonUtil.beanToJson(param));
        request.setBizContent(JsonUtil.beanToJson(param));
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            String result = response.getBody();
            AliRefundParseBean fund = JsonUtil.jsonToBean(result, AliRefundParseBean.class);
            if (fund.getCode().equals("10000") && fund.getMsg().equalsIgnoreCase("Success")) {
                LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u9000\u6b3e\u6210\u529f");
                return fund;
            }
            throw new RuntimeException("\u652f\u4ed8\u5b9d\u9000\u6b3e\u8fd4\u56de\u5931\u8d25:" + result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AliRefundParseBean refund(String out_trade_no, String trade_no, String out_biz_no, double refund_amount) {
        return this.refund(this.getAppId(), this.getPrivateKey(), this.getPublicKey(), out_trade_no, trade_no, out_biz_no, refund_amount);
    }

    public String apppay(AliPayBizParamBean biz) {
        return this.apppay(this.appId, this.privateKey, this.publicKey, biz);
    }

    public String apppay(String appId, String privateKey, String publicKey, AliPayBizParamBean biz) {
        if (StringUtil.isEmpty(appId) || StringUtil.isEmpty(privateKey) || StringUtil.isEmpty(publicKey)) {
            throw new RuntimeException("\u652f\u4ed8\u8d26\u6237\u4fe1\u606f\u7f3a\u5931");
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, privateKey, "json", this.charset, publicKey, this.signType);
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        if (!StringUtil.isEmpty(biz.getBody())) {
            model.setBody(biz.getBody());
        }
        if (!StringUtil.isEmpty(biz.getSubject())) {
            model.setSubject(biz.getSubject());
        }
        if (!StringUtil.isEmpty(biz.getOutTradeNo())) {
            model.setOutTradeNo(biz.getOutTradeNo());
        }
        if (!StringUtil.isEmpty(biz.getTotalAmount())) {
            model.setTotalAmount(biz.getTotalAmount() + "");
        }
        if (!StringUtil.isEmpty(biz.getPassbackParams())) {
            model.setPassbackParams(StringUtil.UrlEncode(biz.getPassbackParams()));
        }
        if (!StringUtil.isEmpty(biz.getNotifyUrl())) {
            request.setNotifyUrl(biz.getNotifyUrl());
        }
        if (!StringUtil.isEmpty(biz.getReturnUrl())) {
            request.setReturnUrl(biz.getReturnUrl());
        }
        model.setProductCode("QUICK_MSECURITY_PAY");
        request.setBizModel((AlipayObject)model);
        try {
            LoggerUtil.info(this.getClass(), "\u652f\u4ed8\u5b9d\u652f\u4ed8\u53c2\u6570AlipayTradeAppPayRequest=:" + JsonUtil.beanToJson(request));
            AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            return response.getBody();
        }
        catch (AlipayApiException e) {
            throw new RuntimeException(e);
        }
    }

    public String payToAli(AliPayToAliParamBean bean) {
        return this.payToAli(this.appId, this.privateKey, this.publicKey, bean);
    }

    public String payToAli(String appId, String privateKey, String publicKey, AliPayToAliParamBean bean) {
        if (StringUtil.isEmpty(appId) || StringUtil.isEmpty(privateKey) || StringUtil.isEmpty(publicKey)) {
            throw new RuntimeException("\u652f\u4ed8\u8d26\u6237\u4fe1\u606f\u7f3a\u5931");
        }
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, privateKey, "json", this.charset, publicKey, this.signType);
        AlipayFundTransToaccountTransferRequest request = new AlipayFundTransToaccountTransferRequest();
        request.setBizContent(JsonUtil.beanToJson(bean));
        try {
            LoggerUtil.info(this.getClass(), "\u8f6c\u8d26\u5230\u652f\u4ed8\u5b9d,\u53c2\u6570:" + JsonUtil.beanToJson(request));
            AlipayFundTransToaccountTransferResponse response = (AlipayFundTransToaccountTransferResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                LoggerUtil.info(this.getClass(), "\u8f6c\u8d26\u5230\u652f\u4ed8\u5b9d\u6210\u529f");
                return "success";
            }
            throw new RuntimeException("\u8f6c\u8d26\u5230\u652f\u4ed8\u5b9d\u5931\u8d25:" + response.getMsg());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void queryPayToAli(String appId, String privateKey, String publicKey, String orderNo) {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, privateKey, "json", this.charset, publicKey, this.signType);
        AlipayFundTransOrderQueryRequest request = new AlipayFundTransOrderQueryRequest();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("out_biz_no", orderNo);
        request.setBizContent("{\"out_biz_no\":\"3142321423432\",\"order_id\":\"20160627110070001502260006780837\"  }");
        try {
            AlipayFundTransOrderQueryResponse response = (AlipayFundTransOrderQueryResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                System.out.println("\u8c03\u7528\u6210\u529f");
            } else {
                System.out.println("\u8c03\u7528\u5931\u8d25");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String ALI_PAY_PRIVATE_KEY = "MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCfTJahejc6B+vCSW1FdXjgJttpR7SnuqMhmZ/2wB7DdUJ8HTibf39shCYFEbrAAbcXaGW2MxUBEht6CwHlD/6Vz6NmyRkEjCrbmKzLN0SNdz274Fu0UEoKzlPgCLIwEVOBTTzZVuyTXMKocIAK3PoKQwNqoBT+tMjlzC3b/Hk6/RZy5AMe4tIEOG9KhcvA4ACcUlOO7ikH2PUo+YREax4gV75J9flesrNy+AKmFIH3tkz+u6QGJqYUps1PorT4l5bEfSIstyQMRRqxZxmB87QJPj9OpRGvj4ia+Dw+i3iNQgvFrfqzFKUSOI+sfR+0EjsgkWluPPI4XAMqPrE8pkjXAgMBAAECggEACaqzJV9uRIZAh0y/ZcyoJioVfIEOdHM9/Qb+jxG/jCrseu2nBsCo8ePfDsWxqH8yJih+q5zT9Hmt0y0h002yLFMqXk1ryDvdSfAs5DQZY+BNjb4isoGAzMESk/DTJ1mV0K3oOGQu/Q5O/bu9+WrJfZ/tcCYAwCgmXNOUINpkXPDwTAh8bidhW5yFvO2MAtTaZYB+Vabj5o15SkSH+TKIkF882QHaeVGBr8iPvh/mcMFaEkPqcKIwfuqFSd4ZDv2+g16Hhgu8yyR+qj/zxtzF69YvwZlw3p6CEVB1JcLsTdx1Whk9P+BxRbXjp++Tj7dfEJB+my8QJqO4wxgJoJDBQQKBgQDPkia1PpAwFbgU0GG0CQE5eoJAXznCoVp6UmqWhfvJID/ToSHv5FAbkD/sHciokZcCSogBuJqThKy+bSDokozIYfdVc+cZpK32J4nhsb2OU7bgJeZpo0goi2Sq2VKLsilV7WLLOuOEhW7uQR5otcbNulZYiz2h1wxwyBf5/ohM4QKBgQDEd0A0BcxjTM+zBXvlvh90hbjph44xZS68QTsq6bkuEAFv9EoPlQkeVg3shNfh2oRMuVoldDFuWPB0LaqdJSt5R73v9bCja5ATC9ogZP/2KikYfpoQY1jncVIjX2yssVXpoILX2rKx0s/Z0aOfizSGkns7ZEYZfdXB9vzkpi3UtwKBgQCFhwAtkcyRkjcz9IUVmsFV53BI1rlCcifRDpmQsSoyzPMiQcKiHp5FzPrB+rrtbZLWH3n0mXuesDer3GnSEwxLj3HbX87nmR9rfS3eqUdGeqXm9ZqOlEJECr+8hEbspLSgmS/3iq93vZqJ3Awi0eTMzTTkitYf+UYAe0epQ0sNIQKBgQDAiq5dTaF1X/3d0O4PxjhFlhgWpkbwmd0nmjZGZDCbuAvwkFVU2BbLqEKVHcwFCIbIOo7iTfFz164v7eFbiOYGQg0fcoXeYrgcMm1fehxwP/lujASpMvQaPrDlAcwbouAzyp7wtOCT7arOKepVnbOofz5OgoNA0FYBdfF6lHIuGQKBgQC7/64PRe9hCsUWVzVM+jITVQAmwvuFIaYjdoZmvVr1C8jtUyFefkVKmuxV3JFyOt5H2ZI0dqbHjibH45Vwuxaf2yaejTXrltFwGew82ETuH03dhRnBTgu3HPlCm0CRB43ryCVTNdwVp1qwBagFud7ZrKoLrR2cIRXoVHPnHfxYRA==";
        String ALI_PAY_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDDI6d306Q8fIfCOaTXyiUeJHkrIvYISRcc73s3vF1ZT7XN8RNPwJxo8pWaJMmvyTn9N4HQ632qJBVHf8sxHi/fEsraprwCtzvzQETrNRwVxLO5jVmRGi60j8Ue1efIlzPXV9je9mkjzOmdssymZkh2QhUrCmZYI/FCEa3/cNMW0QIDAQAB";
        AliPayUtil util = new AliPayUtil("2016122704661078", ALI_PAY_PRIVATE_KEY, ALI_PAY_PUBLIC_KEY);
        util.setSignType("RSA");
        AliPayToAliParamBean param = new AliPayToAliParamBean();
        param.setAmount("1");
        param.setOut_biz_no(UUID.randomUUID().toString().replace("-", ""));
        param.setPayee_account("18606166467");
        param.setPayee_real_name("\u5355\u9e4f\u51b2");
        param.setRemark("\u660e\u661f\u68a6\u6d4b\u8bd5");
        util.payToAli(param);
    }
}

