/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.KDBird;

import cn.easyutil.util.javaUtil.HttpUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.platform.KDBird.bean.KDBirdLogisticsInfoBean;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class KDBirdUtil {
    private static final String ReqURL = "http://api.kdniao.com/Ebusiness/EbusinessOrderHandle.aspx";
    private String eBusinessID;
    private String appKey;

    public KDBirdUtil(String eBusinessID, String appKey) {
        this.eBusinessID = eBusinessID;
        this.appKey = appKey;
    }

    public static KDBirdUtil build(String eBusinessID, String appKey) {
        KDBirdUtil util = new KDBirdUtil(eBusinessID, appKey);
        return util;
    }

    public KDBirdLogisticsInfoBean queryImmediate(String ShipperCode, String LogisticCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ShipperCode", ShipperCode);
        map.put("LogisticCode", LogisticCode);
        String data = JsonUtil.beanToJson(map);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("RequestData", StringUtil.UrlEncode(data));
        param.put("EBusinessID", this.eBusinessID);
        param.put("RequestType", "1002");
        param.put("DataType", "2");
        param.put("DataSign", this.sign(map));
        HttpUtil util = new HttpUtil(ReqURL);
        util.setRequestParam(param);
        String result = util.doUrl();
        if (StringUtil.isEmpty(result)) {
            return null;
        }
        KDBirdLogisticsInfoBean bean = JsonUtil.jsonToBean(result, KDBirdLogisticsInfoBean.class);
        JSONArray array = JSONObject.parseObject((String)result).getJSONArray("Traces");
        if (array == null || array.size() == 0) {
            return bean;
        }
        for (Object object : array) {
            Map<String, Object> info = JsonUtil.jsonToMap(JsonUtil.beanToJson(object));
            KDBirdLogisticsInfoBean.KDBirdAddressInfoBean address = new KDBirdLogisticsInfoBean().new KDBirdLogisticsInfoBean.KDBirdAddressInfoBean();
            if (info == null || info.isEmpty()) continue;
            if (info.get("AcceptStation") != null) {
                address.setAcceptStation(info.get("AcceptStation").toString());
            }
            if (info.get("AcceptTime") != null) {
                address.setAcceptTime(info.get("AcceptTime").toString());
            }
            if (info.get("Remark") != null) {
                address.setRemark(info.get("Remark").toString());
            }
            bean.getInfo().add(address);
        }
        return bean;
    }

    private String sign(Map data) {
        return StringUtil.UrlEncode(StringUtil.base64Encode(StringUtil.toMD5(JsonUtil.beanToJson(data) + this.appKey)));
    }

    public static void main(String[] args) {
        String str = "http://qiniuvideo.mxingm.com/QQ\u622a\u56fe20191113161326.png,http://qiniuvideo.mxingm.com/O1CN01j3TCMz2LTRcS6I4jr_!!1970919693.png";
        String[] split = str.split(",");
        String img = null;
        for (String s : split) {
            if (StringUtil.isEmpty(s)) continue;
            img = s;
            break;
        }
        System.out.println(img);
    }

    public String geteBusinessID() {
        return this.eBusinessID;
    }

    public void seteBusinessID(String eBusinessID) {
        this.eBusinessID = eBusinessID;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}

