/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.FileUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlUtil {
    private static ThreadLocal<Object> xmlVal = new ThreadLocal();
    private static final int CHECK = 1;
    private static final int UPDATE = 2;
    private static final int DELETE = 3;
    private String header = "xml";
    private String attribute;
    private StringBuffer body = new StringBuffer();

    public XmlUtil(String header, String attribute) {
        this.header = header;
        this.attribute = attribute;
    }

    public XmlUtil(String header, String attribute, Map<String, Object> map) {
        this.header = header;
        this.attribute = attribute;
        XmlUtil.mapToXMLTest2(map, this.body);
    }

    public XmlUtil setVal(Map<String, Object> map) {
        XmlUtil.mapToXMLTest2(map, this.body);
        return this;
    }

    public String getXml() {
        return "<" + this.header + " " + this.attribute + ">" + this.body.toString() + "</" + this.header + ">";
    }

    public static Map<String, Object> xmlToMap(String text) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)text);
        }
        catch (DocumentException e1) {
            throw new RuntimeException(e1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (doc == null) {
            return map;
        }
        Element root = doc.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                map.put(e.getName(), XmlUtil.Dom2Map(e));
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map Dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Map> mapList = new ArrayList<Object>();
                if (iter.elements().size() > 0) {
                    Map m = XmlUtil.Dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = new ArrayList();
                            mapList.add((Map)obj);
                            mapList.add(m);
                        }
                        if (obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = new ArrayList();
                        mapList.add((Map)obj);
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    if (obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = (List)obj;
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static Object getVal(String xml, String key) {
        Map<String, Object> map = XmlUtil.xmlToMap(xml);
        XmlUtil.checkVal(map, key, null, 1);
        Object val = xmlVal.get();
        xmlVal.remove();
        return val;
    }

    public static String setVal(String xml, String key, Object val) {
        String root = xml.substring(xml.indexOf("<") + 1, xml.indexOf(">"));
        if (root.startsWith(" ")) {
            root = root.replaceFirst(" ", "");
        }
        String header = root;
        String attribute = "";
        if (root.contains(" ")) {
            int index = root.indexOf(" ");
            header = root.substring(0, index);
            attribute = root.substring(index).replace(" ", "");
        }
        Map<String, Object> map = XmlUtil.xmlToMap(xml);
        map.put(key, val);
        return XmlUtil.mapToXml(map, header, attribute);
    }

    public static String updateVal(String xml, String key, Object val) {
        String root = xml.substring(xml.indexOf("<") + 1, xml.indexOf(">"));
        if (root.startsWith(" ")) {
            root = root.replaceFirst(" ", "");
        }
        String header = root;
        String attribute = "";
        if (root.contains(" ")) {
            int index = root.indexOf(" ");
            header = root.substring(0, index);
            attribute = root.substring(index).replace(" ", "");
        }
        Map<String, Object> map = XmlUtil.xmlToMap(xml);
        XmlUtil.checkVal(map, key, val, 2);
        return XmlUtil.mapToXml(map, header, attribute);
    }

    public static String delVal(String xml, String key) {
        String root = xml.substring(xml.indexOf("<") + 1, xml.indexOf(">"));
        if (root.startsWith(" ")) {
            root = root.replaceFirst(" ", "");
        }
        String header = root;
        String attribute = "";
        if (root.contains(" ")) {
            int index = root.indexOf(" ");
            header = root.substring(0, index);
            attribute = root.substring(index).replace(" ", "");
        }
        Map<String, Object> map = XmlUtil.xmlToMap(xml);
        XmlUtil.checkVal(map, key, null, 3);
        return XmlUtil.mapToXml(map, header, attribute);
    }

    private static void checkVal(Map map, String key, Object val, int type) {
        Set set = map.keySet();
        for (Object object : set) {
            if (map.get(object) instanceof Map) {
                Map obj = (Map)map.get(object);
                XmlUtil.checkVal(obj, key, val, type);
            }
            if (!object.equals(key)) continue;
            if (type == 1) {
                xmlVal.set(map.get(object));
                return;
            }
            if (type == 2) {
                map.put(object, val);
                return;
            }
            if (type != 3) continue;
            map.remove(object);
            return;
        }
    }

    public static String mapToXml(Map map) {
        String root = "xml";
        return XmlUtil.mapToXml(map, root, null);
    }

    public static String mapToXml(Map map, String root, String attribute) {
        StringBuffer bu = new StringBuffer();
        XmlUtil.mapToXMLTest2(map, bu);
        root = root.replace(" ", "");
        attribute = " " + attribute;
        return "<" + root + attribute + ">" + bu.toString() + "</" + root + ">";
    }

    private static void mapToXMLTest2(Map map, StringBuffer sb) {
        Set set = map.keySet();
        for (String key : set) {
            Object value = map.get(key);
            if (null == value) {
                value = "";
            }
            if (value instanceof List) {
                ArrayList list = (ArrayList)map.get(key);
                sb.append("<" + key + "><![CDATA[");
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) instanceof Map) {
                        HashMap hm = (HashMap)list.get(i);
                        XmlUtil.mapToXMLTest2(hm, sb);
                        continue;
                    }
                    sb.append(list.get(i) + ",");
                }
                sb.delete(sb.length() - 1, sb.length());
                sb.append("]]>");
                sb.append("</" + key + ">");
                continue;
            }
            if (value instanceof Map) {
                sb.append("<" + key + ">");
                XmlUtil.mapToXMLTest2((Map)value, sb);
                sb.append("</" + key + ">");
                continue;
            }
            sb.append("<" + key + "><![CDATA[" + value + "]]></" + key + ">");
        }
    }

    public static void main(String[] args) {
        String read = FileUtil.read(new File("D:\\self\\easyutil\\easyutil\\pom.xml"), Charset.forName("utf-8"));
        Map<String, Object> map = XmlUtil.xmlToMap(read);
        System.out.println(JsonUtil.beanToJson(map));
    }
}

