/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.FileUtil;
import cn.easyutil.util.javaUtil.IOUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public class UploadUtil {
    private volatile OSSClient ossClient;
    private String endPoint;
    private String bucketName;
    private String accessKeyId;
    private String accessKeySecret;

    public UploadUtil() {
    }

    public String pictureUpload(InputStream input, String fileFullName, boolean useOSS) {
        byte[] but = IOUtil.inputToByte(input);
        if (!FileUtil.isPicture(but)) {
            LoggerUtil.error(this.getClass(), "\u4e0a\u4f20\u6587\u4ef6\u975e\u56fe\u7247\u7c7b\u578b");
            throw new RuntimeException("file not picture type");
        }
        return this.upload(IOUtil.byteToInput(but), fileFullName);
    }

    public String videoUpload(InputStream input, String fileFullName, boolean useOSS) {
        byte[] but = IOUtil.inputToByte(input);
        if (!FileUtil.isVideo(but)) {
            LoggerUtil.error(this.getClass(), "\u4e0a\u4f20\u6587\u4ef6\u975e\u89c6\u9891\u7c7b\u578b");
            throw new RuntimeException("file not video type");
        }
        return this.upload(IOUtil.byteToInput(but), fileFullName);
    }

    public String docUpload(InputStream input, String fileFullName, boolean useOSS) {
        byte[] but = IOUtil.inputToByte(input);
        if (!FileUtil.isDoc(but)) {
            LoggerUtil.error(this.getClass(), "\u4e0a\u4f20\u6587\u4ef6\u975edoc\u7c7b\u578b");
            throw new RuntimeException("file not doc type");
        }
        return this.upload(IOUtil.byteToInput(but), fileFullName);
    }

    public String audioUpload(InputStream input, String fileFullName, boolean useOSS) {
        byte[] but = IOUtil.inputToByte(input);
        if (!FileUtil.isAudio(but)) {
            LoggerUtil.error(this.getClass(), "\u4e0a\u4f20\u6587\u4ef6\u975e\u97f3\u9891\u7c7b\u578b");
            throw new RuntimeException("file not audio type");
        }
        return this.upload(IOUtil.byteToInput(but), fileFullName, useOSS);
    }

    public String upload(InputStream input, String fileFullName, boolean useOSS) {
        if (useOSS) {
            return this.OSSUpload(input, fileFullName);
        }
        return this.localUpload(input, fileFullName);
    }

    public String upload(InputStream input, String fileFullName) {
        return this.upload(input, fileFullName, true);
    }

    public UploadUtil(String bucketName, String accessKeyId, String accessKeySecret, String endpoint) {
        this.bucketName = bucketName;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endPoint = endpoint;
    }

    public String OSSUpload(InputStream input, String fileFullName) {
        if (this.accessKeyId == null || this.accessKeySecret == null || this.bucketName == null || this.endPoint == null) {
            throw new RuntimeException("OSS param missing");
        }
        OSSClient client = this.getClient();
        ObjectMetadata metadata = new ObjectMetadata();
        int size = 0;
        try {
            size = input.available();
            metadata.setContentLength((long)size);
            LoggerUtil.debug(this.getClass(), "oss\u6587\u4ef6\u4e0a\u4f20,\u6587\u4ef6\u5927\u5c0f:" + size + ",\u6587\u4ef6\u540d:" + fileFullName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        metadata.setCacheControl("no-cache");
        metadata.setHeader("Pragma", (Object)"no-cache");
        metadata.setContentDisposition("filename/filesize=" + fileFullName + "/" + size + "Byte.");
        try {
            LoggerUtil.info(this.getClass(), "oss\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb");
            client.putObject(this.bucketName, fileFullName, input, metadata);
            LoggerUtil.debug(this.getClass(), "oss\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210,\u8def\u5f84\u4e3a:" + fileFullName);
        }
        catch (Exception e) {
            LoggerUtil.error(this.getClass(), "oss\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
        client.shutdown();
        return "https://" + this.bucketName + "." + this.endPoint + "/" + fileFullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSSClient getClient() {
        if (this.ossClient == null) {
            UploadUtil uploadUtil = this;
            synchronized (uploadUtil) {
                if (this.ossClient == null) {
                    this.ossClient = new OSSClient(this.endPoint, this.accessKeyId, this.accessKeySecret);
                }
            }
        }
        return this.ossClient;
    }

    public String localUpload(InputStream input, File file) {
        FileOutputStream fout = null;
        try {
            int size = input.available();
            LoggerUtil.debug(this.getClass(), "\u672c\u5730\u6587\u4ef6\u5b58\u50a8,\u6587\u4ef6\u5927\u5c0f:" + size + ",\u6587\u4ef6\u540d:" + file.getName() + ",\u6587\u4ef6\u5b58\u653e\u8def\u5f84:" + file.getAbsolutePath());
            fout = new FileOutputStream(file);
            byte[] but = new byte[0x100000];
            int length = 0;
            while ((length = input.read(but)) != -1) {
                fout.write(but, 0, length);
            }
            fout.flush();
        }
        catch (Exception e) {
            LoggerUtil.error(this.getClass(), "\u672c\u5730\u6587\u4ef6\u5b58\u50a8\u5931\u8d25:" + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        LoggerUtil.debug(this.getClass(), "\u672c\u5730\u6587\u4ef6\u5b58\u50a8\u6210\u529f,\u8def\u5f84\u4e3a:" + file.getAbsolutePath());
        return file.getAbsolutePath();
    }

    public String localUpload(InputStream input, String fileFullName) {
        File file = new File(fileFullName);
        return this.localUpload(input, file);
    }

    public byte[] localDown(String filePath) {
        File file = null;
        FileInputStream fin = null;
        ByteArrayOutputStream out = null;
        try {
            file = new File(filePath);
            if (!file.exists()) {
                throw new RuntimeException("file[" + filePath + "] do not exist");
            }
            out = new ByteArrayOutputStream();
            fin = new FileInputStream(file);
            byte[] but = new byte[0x100000];
            int length = 0;
            while ((length = fin.read(but)) != -1) {
                out.write(but, 0, length);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                fin.close();
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        UploadUtil util = new UploadUtil("mimikko-test", "LTAI4GAxWdob1nY9LTVxsjrk", "yonU6NQfzrEEu5W5jiGRabiaepK3Be", "oss-cn-shanghai.aliyuncs.com");
        String result = util.OSSUpload(new FileInputStream(new File("D://sign.png")), "picture/" + UUID.randomUUID().toString().replace("-", "") + ".png");
        System.out.println(result);
    }
}

