/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.IOUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.PDFUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.javaUtil.bean.MergeImageBean;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;

public class ImageUtil {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private static int[] fontType = new int[]{0, 1, 2, 3};
    private static String[] fonts = new String[]{"\u5b8b\u4f53"};
    private static final List<String> IMAGE_TYPE = new ArrayList<String>();

    public static void creatQRcode(String text, String outFilePath) {
        ImageUtil.creatQRcode(text, null, outFilePath, 300);
    }

    public static void creatQRcode(String text, String logoPath, String outFilePath) {
        ImageUtil.creatQRcode(text, logoPath, outFilePath, 300);
    }

    public static void creatQRcode(String text, String logoPath, String outFilePath, int size) {
        ImageUtil.creatQRcode(text, logoPath, outFilePath, size, null);
    }

    public static void creatQRcode(String text, HttpServletResponse response) {
        ImageUtil.creatQRcode(text, null, null, 300, response);
    }

    public static void creatQRcode(String text, String logoPath, HttpServletResponse response) {
        ImageUtil.creatQRcode(text, logoPath, null, 300, response);
    }

    public static void creatQRcode(String text, String logoPath, HttpServletResponse response, int size) {
        ImageUtil.creatQRcode(text, logoPath, null, size, response);
    }

    private static void creatQRcode(String text, String logoPath, String outFilePath, int size, HttpServletResponse response) {
        BufferedImage image = ImageUtil.creatQRcode(text, size, logoPath);
        if (outFilePath != null && !outFilePath.equals("")) {
            File file = new File(outFilePath);
            try {
                ImageIO.write((RenderedImage)image, "png", file);
                LoggerUtil.debug(ImageUtil.class, "QR code create success");
            }
            catch (IOException e) {
                LoggerUtil.error(ImageUtil.class, "QR code create failed", e);
            }
            return;
        }
        if (response != null) {
            try {
                ImageIO.write((RenderedImage)image, "png", (OutputStream)response.getOutputStream());
                response.getOutputStream().flush();
                LoggerUtil.debug(ImageUtil.class, "QR code create success");
            }
            catch (IOException e) {
                LoggerUtil.error(ImageUtil.class, "QR code create failed", e);
            }
            return;
        }
        throw new NullPointerException("output of the QR code must not be null");
    }

    public static BufferedImage creatQRcode(String text, Integer size, String logoPath) {
        if (size == null || size <= 0) {
            size = 300;
        }
        BufferedImage image = null;
        try {
            File logoPic;
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 1);
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bitMatrix = multiFormatWriter.encode(text, BarcodeFormat.QR_CODE, size.intValue(), size.intValue(), hints);
            int codeWidth = bitMatrix.getWidth();
            int codeHeight = bitMatrix.getHeight();
            image = new BufferedImage(codeWidth, codeHeight, 1);
            for (int i = 0; i < codeWidth; ++i) {
                for (int j = 0; j < codeHeight; ++j) {
                    image.setRGB(i, j, bitMatrix.get(i, j) ? -16777216 : -1);
                }
            }
            if (logoPath != null && !"".equals(logoPath) && (logoPic = new File(logoPath)).exists()) {
                Graphics2D g = image.createGraphics();
                BufferedImage logo = ImageIO.read(logoPic);
                int widthLogo = logo.getWidth(null) > image.getWidth() * 2 / 10 ? image.getWidth() * 2 / 10 : logo.getWidth(null);
                int heightLogo = logo.getHeight(null) > image.getHeight() * 2 / 10 ? image.getHeight() * 2 / 10 : logo.getHeight(null);
                int x = (image.getWidth() - widthLogo) / 2;
                int y = (image.getHeight() - heightLogo) / 2;
                g.drawImage(logo, x, y, widthLogo, heightLogo, null);
                g.drawRoundRect(x, y, widthLogo, heightLogo, 15, 15);
                g.setStroke(new BasicStroke(2.0f));
                g.setColor(Color.WHITE);
                g.drawRect(x, y, widthLogo, heightLogo);
                g.dispose();
                logo.flush();
                image.flush();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return image;
    }

    public static String readQRcode(BufferedImage image) {
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            Result result = new MultiFormatReader().decode(binaryBitmap, hints);
            return result.getText();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readQRcode(String filePath) {
        try {
            BufferedImage image = ImageIO.read(new File(filePath));
            return ImageUtil.readQRcode(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readQRcode(InputStream input) {
        try {
            BufferedImage image = ImageIO.read(input);
            return ImageUtil.readQRcode(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createVerificationCode(String filePath, String code) {
        ImageUtil.createVerificationCode(0, 0, filePath, code);
    }

    public static void createVerificationCode(HttpServletResponse response, String code) {
        ImageUtil.createVerificationCode(0, 0, response, code);
    }

    public static void createVerificationCode(int w, int h, HttpServletResponse response, String code) {
        BufferedImage img = ImageUtil.outputImage(w, h, code);
        if (response != null) {
            try {
                ImageIO.write((RenderedImage)img, "PNG", (OutputStream)response.getOutputStream());
                LoggerUtil.info(ImageUtil.class, "verification code [" + code + "] export success");
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    response.getOutputStream().flush();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void createVerificationCode(int w, int h, String filePath, String code) {
        if (filePath == null) {
            return;
        }
        BufferedImage img = ImageUtil.outputImage(w, h, code);
        try {
            ImageIO.write((RenderedImage)img, "PNG", new File(filePath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BufferedImage outputImage(int w, int h, String code) {
        if (w <= 0 || h <= 0) {
            int length = 0;
            char[] chars = code.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] >= '\u0000' && chars[i] <= '\u007f') {
                    ++length;
                    continue;
                }
                length += 2;
            }
            w = length * 40;
            h = length * 30 / 4 < 50 ? 50 : length * 30 / 4;
        }
        int verifySize = code.length();
        BufferedImage image = null;
        try {
            image = new BufferedImage(w, h, 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Random rand = new Random();
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[5];
        Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
        float[] fractions = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorSpaces[rand.nextInt(colorSpaces.length)];
            fractions[i] = rand.nextFloat();
        }
        Arrays.sort(fractions);
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, w, h);
        Color c = ImageUtil.getRandColor(200, 250);
        g2.setColor(c);
        g2.fillRect(0, 2, w, h - 4);
        Random random = new Random();
        g2.setColor(ImageUtil.getRandColor(160, 200));
        for (int i = 0; i < code.length() * 10; ++i) {
            int x = random.nextInt(w - 1);
            int y = random.nextInt(h - 1);
            int xl = random.nextInt(6) + 1;
            int yl = random.nextInt(12) + 1;
            g2.drawLine(x, y, x + xl + 40, y + yl + 20);
        }
        float yawpRate = (float)w / 1000.0f;
        int area = (int)(yawpRate * (float)w * (float)h);
        for (int i = 0; i < area; ++i) {
            int x = random.nextInt(w);
            int y = random.nextInt(h);
            int rgb = ImageUtil.getRandomIntColor();
            image.setRGB(x, y, rgb);
        }
        int fontSize = h - 4;
        char[] chars = code.toCharArray();
        for (int i = 0; i < verifySize; ++i) {
            g2.setColor(ImageUtil.getRandColor(100, 160));
            Font font = new Font(fonts[new Random().nextInt(fonts.length)], fontType[new Random().nextInt(fontType.length)], fontSize);
            g2.setFont(font);
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(0.7853981633974483 * rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), w / verifySize * i + fontSize / 2, h / 2);
            g2.setTransform(affine);
            g2.drawChars(chars, i, 1, (w - 10) / verifySize * i + 5, h / 2 + fontSize / 2 - 10);
        }
        g2.dispose();
        return image;
    }

    private static Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static int getRandomIntColor() {
        int[] rgb = ImageUtil.getRandomRgb();
        int color = 0;
        for (int c : rgb) {
            color <<= 8;
            color |= c;
        }
        return color;
    }

    private static int[] getRandomRgb() {
        Random random = new Random();
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = random.nextInt(255);
        }
        return rgb;
    }

    public static byte[] mergeImage(int weight, int height, List<MergeImageBean> li) {
        BufferedImage combined = new BufferedImage(weight, height, 1);
        Graphics g = combined.getGraphics();
        for (MergeImageBean bean : li) {
            g.drawImage(bean.getImg(), bean.getX(), bean.getY(), bean.getWeight(), bean.getHeight(), null);
        }
        return ImageUtil.imgToByte(combined);
    }

    public static byte[] resize(byte[] but, int targetW, int targetH, boolean ... equalRatio) {
        return ImageUtil.resize(IOUtil.byteToInput(but), targetW, targetH, equalRatio);
    }

    public static byte[] resize(InputStream in, int targetW, int targetH, boolean ... equalRatio) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (equalRatio.length == 0) {
            equalRatio = new boolean[]{true};
        }
        try {
            if (equalRatio[0]) {
                if (targetH > targetW) {
                    Thumbnails.of((InputStream[])new InputStream[]{in}).height(targetH).toOutputStream((OutputStream)out);
                } else {
                    Thumbnails.of((InputStream[])new InputStream[]{in}).width(targetW).toOutputStream((OutputStream)out);
                }
            } else {
                Thumbnails.of((InputStream[])new InputStream[]{in}).forceSize(targetW, targetH).toOutputStream((OutputStream)out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] resize(BufferedImage source, int targetW, int targetH, boolean ... equalRatio) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (equalRatio.length == 0) {
            equalRatio = new boolean[]{true};
        }
        try {
            if (equalRatio[0]) {
                if (targetH > targetW) {
                    Thumbnails.of((BufferedImage[])new BufferedImage[]{source}).outputFormat("png").height(targetH).toOutputStream((OutputStream)out);
                } else {
                    Thumbnails.of((BufferedImage[])new BufferedImage[]{source}).outputFormat("png").width(targetW).toOutputStream((OutputStream)out);
                }
            } else {
                Thumbnails.of((BufferedImage[])new BufferedImage[]{source}).outputFormat("png").forceSize(targetW, targetH).toOutputStream((OutputStream)out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] updateImgType(InputStream in, String type) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Thumbnails.of((InputStream[])new InputStream[]{in}).scale(1.0).outputFormat(type).toOutputStream((OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] svgToPng(InputStream in) {
        JPEGTranscoder t = new JPEGTranscoder();
        t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        TranscoderInput input = new TranscoderInput(in);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        try {
            t.transcode(input, output);
            ostream.flush();
            return ostream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] imgToByte(BufferedImage source) {
        return ImageUtil.imgToByte(source, "PNG");
    }

    public static byte[] imgToByte(BufferedImage source, String formartName) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] but = null;
        try {
            ImageIO.write((RenderedImage)source, formartName, out);
            byte[] byArray = but = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] toBlurred(InputStream in, float scale) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (scale > 1.0f) {
            scale = 0.9f;
        }
        if (scale <= 0.0f) {
            scale = 0.01f;
        }
        try {
            Thumbnails.of((InputStream[])new InputStream[]{in}).scale(1.0).outputQuality(scale).toOutputStream((OutputStream)out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] addWatermark(InputStream source, InputStream watermark, Positions ... positions) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Thumbnails.of((InputStream[])new InputStream[]{source}).scale(0.8).outputQuality(0.8f).watermark((Position)(positions.length > 0 ? positions[0] : Positions.BOTTOM_RIGHT), ImageIO.read(watermark), 0.25f).toOutputStream((OutputStream)out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] imgToByte(InputStream in) {
        return IOUtil.inputToByte(in);
    }

    public static BufferedImage byteToImg(byte[] but) {
        ByteArrayInputStream in = new ByteArrayInputStream(but);
        try {
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isTransparent(InputStream in) throws IOException {
        BufferedImage bi = ImageIO.read(in);
        int width = bi.getWidth();
        int height = bi.getHeight();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int dip = bi.getRGB(j, i);
                if (dip >> 24 == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static BufferedImage byteToImg(InputStream in) {
        try {
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static BufferedImage createSeal(String companyName, String centerMessage) {
        return ImageUtil.createSeal(companyName, centerMessage, null, true);
    }

    public static BufferedImage createSeal(String companyName, String centerMessage, String year, boolean addStar) {
        if (StringUtil.isEmpty(companyName)) {
            throw new RuntimeException("\u672a\u63d0\u4f9b\u4f01\u4e1a\u540d\u79f0");
        }
        int WIDTH = 500;
        int HEIGHT = 500;
        BufferedImage buffImg = new BufferedImage(WIDTH, HEIGHT, 1);
        Graphics2D g2d = buffImg.createGraphics();
        buffImg = g2d.getDeviceConfiguration().createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D g = buffImg.createGraphics();
        g.setColor(Color.RED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int radius = HEIGHT / 3;
        int CENTERX = WIDTH / 2;
        int CENTERY = HEIGHT / 2;
        Ellipse2D.Double circle = new Ellipse2D.Double();
        circle.setFrameFromCenter(CENTERX, CENTERY, CENTERX + radius, CENTERY + radius);
        g.draw(circle);
        if (addStar) {
            g.setFont(new Font("\u5b8b\u4f53", 1, 120));
            g.drawString("\u2605", CENTERX - 60, CENTERY + 40);
        }
        if (!StringUtil.isEmpty(centerMessage)) {
            char[] chars = centerMessage.toCharArray();
            int charSize = 0;
            int maxCharSize = 14;
            int drawCenterMessageX = 100;
            for (char c : chars) {
                if (StringUtil.isBaseChar(c)) {
                    ++charSize;
                    continue;
                }
                charSize += 2;
            }
            if (charSize < maxCharSize) {
                StringBuffer sb = new StringBuffer();
                for (int supSize = (maxCharSize - charSize) / 2; supSize > 0; --supSize) {
                    sb.append(" ");
                }
                centerMessage = sb.toString() + centerMessage;
            }
            g.setFont(new Font("\u5b8b\u4f53", 0, 30));
            g.drawString(centerMessage, CENTERX - drawCenterMessageX, CENTERY + 80);
        }
        if (!StringUtil.isEmpty(year)) {
            g.setFont(new Font("\u5b8b\u4f53", 0, 20));
            g.drawString(year, CENTERX - 60, CENTERY + 110);
        }
        String[] messages = companyName.split("", 0);
        int ilength = messages.length;
        int fontsize = 40;
        Font f = new Font("Serif", 1, fontsize);
        FontRenderContext context = g.getFontRenderContext();
        Rectangle2D bounds = f.getStringBounds(companyName, context);
        double char_interval = bounds.getWidth() / (double)ilength;
        double ascent = -bounds.getY();
        int first = 0;
        int second = 0;
        boolean odd = false;
        if (ilength % 2 == 1) {
            first = (ilength - 1) / 2;
            odd = true;
        } else {
            first = ilength / 2 - 1;
            second = ilength / 2;
            odd = false;
        }
        double radius2 = (double)radius - ascent;
        double x0 = CENTERX;
        double y0 = (double)(CENTERY - radius) + ascent;
        double a = 2.0 * Math.asin(char_interval / (2.0 * radius2));
        if (odd) {
            Font f2;
            AffineTransform transform;
            double ay;
            double ax;
            double aa;
            int i;
            g.setFont(f);
            g.drawString(messages[first], (float)(x0 - char_interval / 2.0), (float)y0);
            for (i = first + 1; i < ilength; ++i) {
                aa = (double)(i - first) * a;
                ax = radius2 * Math.sin(aa);
                ay = radius2 - radius2 * Math.cos(aa);
                transform = AffineTransform.getRotateInstance(aa);
                f2 = f.deriveFont(transform);
                g.setFont(f2);
                g.drawString(messages[i], (float)(x0 + ax - char_interval / 2.0 * Math.cos(aa)), (float)(y0 + ay - char_interval / 2.0 * Math.sin(aa)));
            }
            for (i = first - 1; i > -1; --i) {
                aa = (double)(first - i) * a;
                ax = radius2 * Math.sin(aa);
                ay = radius2 - radius2 * Math.cos(aa);
                transform = AffineTransform.getRotateInstance(-aa);
                f2 = f.deriveFont(transform);
                g.setFont(f2);
                g.drawString(messages[i], (float)(x0 - ax - char_interval / 2.0 * Math.cos(aa)), (float)(y0 + ay + char_interval / 2.0 * Math.sin(aa)));
            }
        } else {
            Font f2;
            AffineTransform transform;
            double ay;
            double ax;
            double aa;
            int i;
            for (i = second; i < ilength; ++i) {
                aa = ((double)(i - second) + 0.5) * a;
                ax = radius2 * Math.sin(aa);
                ay = radius2 - radius2 * Math.cos(aa);
                transform = AffineTransform.getRotateInstance(aa);
                f2 = f.deriveFont(transform);
                g.setFont(f2);
                g.drawString(messages[i], (float)(x0 + ax - char_interval / 2.0 * Math.cos(aa)), (float)(y0 + ay - char_interval / 2.0 * Math.sin(aa)));
            }
            for (i = first; i > -1; --i) {
                aa = ((double)(first - i) + 0.5) * a;
                ax = radius2 * Math.sin(aa);
                ay = radius2 - radius2 * Math.cos(aa);
                transform = AffineTransform.getRotateInstance(-aa);
                f2 = f.deriveFont(transform);
                g.setFont(f2);
                g.drawString(messages[i], (float)(x0 - ax - char_interval / 2.0 * Math.cos(aa)), (float)(y0 + ay + char_interval / 2.0 * Math.sin(aa)));
            }
        }
        return buffImg;
    }

    public static void saveImg(BufferedImage img, File file) {
        ImageUtil.saveImg(img, "png", file);
    }

    public static void saveImg(BufferedImage img, String format, File file) {
        try {
            ImageIO.write((RenderedImage)img, format, new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        File file = new File("D:\\platform-takedata\\chongqinghouse\\\u623f\u4ea7\u7b7e\u540d\u6388\u6743\\\u5357\u6295\u6b63\u672c.pdf");
        File out = new File("D:\\platform-takedata\\chongqinghouse\\\u623f\u4ea7\u7b7e\u540d\u6388\u6743\\nantou.jpg");
        PDFUtil.pdfToImage((InputStream)new FileInputStream(file), new FileOutputStream(out), 100);
    }

    static {
        IMAGE_TYPE.add("jpg");
        IMAGE_TYPE.add("png");
        IMAGE_TYPE.add("jpeg");
    }
}

