/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.IOUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.annotation.EmailCallBack;
import com.sun.mail.pop3.POP3Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailUtil {
    private String username;
    private String host;
    private String port;
    private String password;
    private String charset = "gbk";
    private int portNo;

    public EmailUtil(String username, String password) {
        this.username = username;
        this.password = password;
        Map<String, String> map = EmailUtil.getPort(username);
        this.port = map.get("port");
        this.host = map.get("host");
    }

    public EmailUtil(String username, String password, String host, String port) {
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public int getPortNo() {
        if (this.port.equals("pop3")) {
            this.setPortNo(995);
        }
        return this.portNo;
    }

    public void setPortNo(int portNo) {
        this.portNo = portNo;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getHost() {
        if (this.host == null) {
            throw new NullPointerException("the field [host] must not be null ,please set the [SMTP] server host,example:smtp.163.com");
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        if (this.port == null) {
            throw new NullPointerException("the field [port] must not be null,please set the [SMTP] server port,example:stand by SSL = 465,QQ = 587,default = 25");
        }
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static void sendEmail(String username, String password, String title, String text, String ... sendTo) {
        EmailUtil.send(new EmailUtil(username, password), new File[0], title, text, sendTo);
    }

    public static void sendEmail(String username, String password, String title, String text, File[] file, String ... sendTo) {
        EmailUtil.send(new EmailUtil(username, password), file, title, text, sendTo);
    }

    public static void sendEmail(EmailUtil ea, String title, String text, File[] file, String ... sendTo) {
        EmailUtil.send(ea, file, title, text, sendTo);
    }

    public static void sendEmail(EmailUtil ea, String title, String text, String ... sendTo) {
        EmailUtil.send(ea, new File[0], title, text, sendTo);
    }

    private static void send(final EmailUtil ea, File[] files, String title, String text, String[] sendTo) {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.auth", "true");
        properties.setProperty("mail.transport.protocol", ea.getPort());
        properties.setProperty("mail.host", ea.getHost());
        properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        properties.setProperty("mail.smtp.socketFactory.port", "465");
        properties.setProperty("mail.smtp.port", "465");
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){
            String sendUserName;
            String sendPassword;
            {
                this.sendUserName = ea.getUsername();
                this.sendPassword = ea.getPassword();
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(this.sendUserName, this.sendPassword);
            }
        });
        session.setDebug(true);
        MimeMessage msg = new MimeMessage(session);
        MimeMultipart msgMultipart = new MimeMultipart("mixed");
        for (int i = 0; i < files.length; ++i) {
            MimeBodyPart attch1 = new MimeBodyPart();
            String path = files[i].getAbsolutePath();
            FileDataSource ds1 = new FileDataSource(path);
            DataHandler dh1 = new DataHandler((DataSource)ds1);
            try {
                attch1.setDataHandler(dh1);
                attch1.setFileName(path.substring(path.lastIndexOf(File.separator), path.length()));
                msgMultipart.addBodyPart((BodyPart)attch1);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MimeBodyPart content = new MimeBodyPart();
        try {
            msg.setFrom(ea.getUsername());
            msg.setSubject(title);
            InternetAddress[] ins = new InternetAddress[sendTo.length];
            for (int i = 0; i < ins.length; ++i) {
                InternetAddress in;
                ins[i] = in = new InternetAddress(sendTo[i]);
            }
            msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])ins);
            msg.setContent((Multipart)msgMultipart);
            msgMultipart.addBodyPart((BodyPart)content);
        }
        catch (MessagingException e) {
            LoggerUtil.error(EmailUtil.class, "user of [" + ea.getUsername() + "] send email failed", e);
            throw new RuntimeException(e);
        }
        MimeMultipart bodyMultipart = new MimeMultipart("related");
        MimeBodyPart htmlPart = new MimeBodyPart();
        try {
            content.setContent((Multipart)bodyMultipart);
            bodyMultipart.addBodyPart((BodyPart)htmlPart);
            htmlPart.setContent((Object)text, "text/html;charset=" + ea.getCharset());
            msg.saveChanges();
        }
        catch (MessagingException e) {
            LoggerUtil.error(EmailUtil.class, "user of [" + ea.getUsername() + "] send email failed", e);
            throw new RuntimeException(e);
        }
        try {
            Transport.send((Message)msg);
            LoggerUtil.debug(EmailUtil.class, "user of [" + ea.getUsername() + " send email to [" + JsonUtil.beanToJson(sendTo) + "] success");
        }
        catch (Exception e) {
            LoggerUtil.error(EmailUtil.class, "user of [" + ea.getUsername() + "] send email failed", e);
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> getPort(String username) {
        if (username == null || !username.contains("@")) {
            throw new RuntimeException("the email flag @ not found with the username [" + username + "],please use the mothed of sendEmail(EasyEmailUtil ea, String title, String text, File[] file,String... sendTo)");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (username.endsWith("@qq.com")) {
            result.put("host", "smtp.qq.com");
            result.put("port", "587");
        } else {
            String host = username.substring(username.indexOf("@") + 1);
            result.put("host", "smtp." + host);
            result.put("port", "25");
        }
        return result;
    }

    public static EmailMessage readEmail(String username, String password) {
        return EmailUtil.readEmail(username, password, -1, null).get(0);
    }

    public static EmailMessage readEmail(String username, String password, EmailCallBack call) {
        return EmailUtil.readEmail(username, password, -1, call).get(0);
    }

    public static List<EmailMessage> readEmail(String username, String password, int length, EmailCallBack call) {
        if (!username.contains("@")) {
            throw new RuntimeException("the email flag @ not found with the username [" + username + "],please use the mothed of readEmail(EasyEmailUtil ea,int start,int end,EmailCallBack call)");
        }
        String str = username.substring(username.indexOf("@") + 1);
        str = str.substring(0, str.indexOf("."));
        EmailUtil ea = new EmailUtil(username, password, "pop." + str + ".com", "pop3");
        return EmailUtil.readEmail(ea, -1, length, call);
    }

    public static List<EmailMessage> readEmail(EmailUtil ea, int start, int end, EmailCallBack call) {
        String protocol = ea.getPort();
        String host = ea.getHost();
        int port = ea.getPortNo();
        String username = ea.getUsername();
        String password = ea.getPassword();
        Properties props = new Properties();
        props.put("mail." + ea.getPort() + ".ssl.enable", (Object)true);
        props.put("mail." + ea.getPort() + ".host", host);
        props.put("mail." + ea.getPort() + ".port", (Object)port);
        Session session = Session.getDefaultInstance((Properties)props);
        Store store = null;
        Folder folder = null;
        ArrayList<EmailMessage> result = new ArrayList<EmailMessage>();
        try {
            store = session.getStore(protocol);
            store.connect(username, password);
            folder = store.getFolder("INBOX");
            folder.open(1);
            int size = folder.getMessageCount();
            if (start < 0) {
                start = size - end + 1 < 0 || size - end + 1 > size ? size : size - end + 1;
                end = size;
            }
            if (end > size || end < start) {
                end = size;
            }
            if (end <= 1) {
                start = size;
                end = size;
            }
            Message[] messages = folder.getMessages(start, end);
            for (int i = 0; i < messages.length; ++i) {
                EmailMessage mess = new EmailMessage();
                Message message = messages[i];
                String from = message.getFrom()[0].toString();
                String subject = message.getSubject();
                Date date = message.getSentDate();
                mess.setFrom(from);
                mess.setReciveTime(date);
                mess.setTitle(subject);
                mess.setContent(message.getContent().toString());
                result.add(mess);
                if (call == null) continue;
                call.call(message);
            }
            ArrayList<EmailMessage> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            LoggerUtil.error(EmailUtil.class, "user of [" + ea.getUsername() + "] read email failed", e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (folder != null) {
                    folder.close(false);
                }
                if (store != null) {
                    store.close();
                }
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        EmailCallBack callBack = new EmailCallBack(){

            @Override
            public void call(Message message) {
                try {
                    Object content = message.getContent();
                    InputStream inputStream = ((POP3Message)message).getMimeStream();
                    byte[] bytes = IOUtil.inputToByte(inputStream);
                    FileOutputStream out = new FileOutputStream(new File("D://email.html"));
                    out.write(bytes);
                    out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        };
        EmailMessage message = EmailUtil.readEmail("547595531@qq.com", "wnzxmgthwjskbfeb", callBack);
        System.out.println(message);
    }

    static class EmailMessage {
        private String from;
        private String title;
        private Date reciveTime;
        private String content;

        EmailMessage() {
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Date getReciveTime() {
            return this.reciveTime;
        }

        public void setReciveTime(Date reciveTime) {
            this.reciveTime = reciveTime;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

