/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.filter;

import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.filter.SaFilter;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaFilterErrorStrategy;
import cn.dev33.satoken.router.SaRouter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=-100)
public class SaServletFilter
implements SaFilter,
Filter {
    public List<String> includeList = new ArrayList<String>();
    public List<String> excludeList = new ArrayList<String>();
    public SaFilterAuthStrategy auth = r -> {};
    public SaFilterErrorStrategy error = e -> {
        throw new SaTokenException(e).setCode(20105);
    };
    public SaFilterAuthStrategy beforeAuth = r -> {};

    public SaServletFilter addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaServletFilter addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaServletFilter setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SaServletFilter setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public SaServletFilter setAuth(SaFilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SaServletFilter setError(SaFilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SaServletFilter setBeforeAuth(SaFilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.beforeAuth.run(null);
            SaRouter.match(this.includeList).notMatch(this.excludeList).check(r -> this.auth.run(null));
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (Throwable e) {
            String result;
            String string = result = e instanceof BackResultException ? e.getMessage() : String.valueOf(this.error.run(e));
            if (response.getContentType() == null) {
                response.setContentType("text/plain; charset=utf-8");
            }
            response.getWriter().print(result);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

