/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.config;

import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SaTokenConfigFactory {
    public static String configPath = "sa-token.properties";

    private SaTokenConfigFactory() {
    }

    public static SaTokenConfig createConfig() {
        return SaTokenConfigFactory.createConfig(configPath);
    }

    public static SaTokenConfig createConfig(String path) {
        Map<String, String> map = SaTokenConfigFactory.readPropToMap(path);
        return (SaTokenConfig)SaTokenConfigFactory.initPropByMap(map, new SaTokenConfig());
    }

    private static Map<String, String> readPropToMap(String propertiesPath) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        try {
            InputStream is = SaTokenConfigFactory.class.getClassLoader().getResourceAsStream(propertiesPath);
            if (is == null) {
                return null;
            }
            Properties prop = new Properties();
            prop.load(is);
            for (String key : prop.stringPropertyNames()) {
                map.put(key, prop.getProperty(key));
            }
        }
        catch (IOException e) {
            throw new SaTokenException("\u914d\u7f6e\u6587\u4ef6(" + propertiesPath + ")\u52a0\u8f7d\u5931\u8d25", e).setCode(10021);
        }
        return map;
    }

    private static Object initPropByMap(Map<String, String> map, Object obj) {
        Class<?> cs;
        if (map == null) {
            map = new HashMap<String, String>(16);
        }
        if (obj instanceof Class) {
            cs = (Class<?>)obj;
            obj = null;
        } else {
            cs = obj.getClass();
        }
        for (Field field : cs.getDeclaredFields()) {
            String value = map.get(field.getName());
            if (value == null) continue;
            try {
                Object valueConvert = SaFoxUtil.getValueByType(value, field.getType());
                field.setAccessible(true);
                field.set(obj, valueConvert);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new SaTokenException("\u5c5e\u6027\u8d4b\u503c\u51fa\u9519\uff1a" + field.getName(), e).setCode(10022);
            }
        }
        return obj;
    }
}

