/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SaTokenDaoDefaultImpl
implements SaTokenDao {
    public Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    public Map<String, Long> expireMap = new ConcurrentHashMap<String, Long>();
    public Thread refreshThread;
    public volatile boolean refreshFlag;

    public SaTokenDaoDefaultImpl() {
        this.initRefreshThread();
    }

    @Override
    public String get(String key) {
        this.clearKeyByTimeout(key);
        return (String)this.dataMap.get(key);
    }

    @Override
    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        this.dataMap.put(key, value);
        this.expireMap.put(key, timeout == -1L ? -1L : System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public void update(String key, String value) {
        if (this.getKeyTimeout(key) == -2L) {
            return;
        }
        this.dataMap.put(key, value);
    }

    @Override
    public void delete(String key) {
        this.dataMap.remove(key);
        this.expireMap.remove(key);
    }

    @Override
    public long getTimeout(String key) {
        return this.getKeyTimeout(key);
    }

    @Override
    public void updateTimeout(String key, long timeout) {
        this.expireMap.put(key, System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public Object getObject(String key) {
        this.clearKeyByTimeout(key);
        return this.dataMap.get(key);
    }

    @Override
    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        this.dataMap.put(key, object);
        this.expireMap.put(key, timeout == -1L ? -1L : System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public void updateObject(String key, Object object) {
        if (this.getKeyTimeout(key) == -2L) {
            return;
        }
        this.dataMap.put(key, object);
    }

    @Override
    public void deleteObject(String key) {
        this.dataMap.remove(key);
        this.expireMap.remove(key);
    }

    @Override
    public long getObjectTimeout(String key) {
        return this.getKeyTimeout(key);
    }

    @Override
    public void updateObjectTimeout(String key, long timeout) {
        this.expireMap.put(key, System.currentTimeMillis() + timeout * 1000L);
    }

    void clearKeyByTimeout(String key) {
        Long expirationTime = this.expireMap.get(key);
        if (expirationTime != null && expirationTime != -1L && expirationTime < System.currentTimeMillis()) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
        }
    }

    long getKeyTimeout(String key) {
        this.clearKeyByTimeout(key);
        Long expire = this.expireMap.get(key);
        if (expire == null) {
            return -2L;
        }
        if (expire == -1L) {
            return -1L;
        }
        long timeout = (expire - System.currentTimeMillis()) / 1000L;
        if (timeout < 0L) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
            return -2L;
        }
        return timeout;
    }

    public void refreshDataMap() {
        Iterator<String> keys = this.expireMap.keySet().iterator();
        while (keys.hasNext()) {
            this.clearKeyByTimeout(keys.next());
        }
    }

    public void initRefreshThread() {
        if (SaManager.getConfig().getDataRefreshPeriod() <= 0) {
            return;
        }
        this.refreshFlag = true;
        this.refreshThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        try {
                            if (!this.refreshFlag) {
                                return;
                            }
                            this.refreshDataMap();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int dataRefreshPeriod = SaManager.getConfig().getDataRefreshPeriod();
                        if (dataRefreshPeriod <= 0) {
                            dataRefreshPeriod = 1;
                        }
                        Thread.sleep(dataRefreshPeriod * 1000);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        this.refreshThread.start();
    }

    public void endRefreshThread() {
        this.refreshFlag = false;
    }

    @Override
    public List<String> searchData(String prefix, String keyword, int start, int size) {
        return SaFoxUtil.searchList(this.expireMap.keySet(), prefix, keyword, start, size);
    }
}

