/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.mongoHelper.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatUtils {
    public static Pattern regex = Pattern.compile("\\$\\{([^}]*)\\}");

    public static String bson(String json) {
        json = FormatUtils.transString(json);
        String blank = "    ";
        String indent = "";
        StringBuilder sb = new StringBuilder();
        block7: for (char c : json.toCharArray()) {
            switch (c) {
                case '{': {
                    indent = indent + blank;
                    sb.append("{\n").append(indent);
                    continue block7;
                }
                case '}': {
                    indent = indent.substring(0, indent.length() - blank.length());
                    sb.append("\n").append(indent).append("}");
                    continue block7;
                }
                case '[': {
                    indent = indent + blank;
                    sb.append("[\n").append(indent);
                    continue block7;
                }
                case ']': {
                    indent = indent.substring(0, indent.length() - blank.length());
                    sb.append("\n").append(indent).append("]");
                    continue block7;
                }
                case ',': {
                    sb.append(",\n").append(indent);
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String transString(String str) {
        str = str.replace(", ", ",").replace("{\"$oid\":", "${");
        List<String> temp = FormatUtils.getContentInfo(str);
        for (String tp : temp) {
            str = str.replace("${" + tp + "}", "ObjectId(" + tp.trim() + ")");
        }
        return str;
    }

    private static List<String> getContentInfo(String content) {
        Matcher matcher = regex.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }
}

