/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.mongoHelper.utils;

import cn.craccd.mongoHelper.utils.CriteriaOrWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.data.mongodb.core.query.Criteria;

public abstract class CriteriaWrapper {
    boolean andLink = true;
    Criteria criteria;
    List<Criteria> list = new ArrayList<Criteria>();

    public Criteria build() {
        this.criteria = new Criteria();
        if (this.list.size() > 0) {
            if (this.andLink) {
                this.criteria.andOperator(this.listToArry(this.list));
            } else {
                this.criteria.orOperator(this.listToArry(this.list));
            }
        }
        return this.criteria;
    }

    private Criteria[] listToArry(List<Criteria> list) {
        return list.toArray(new Criteria[list.size()]);
    }

    public CriteriaWrapper eq(String column, Object params) {
        this.list.add(Criteria.where((String)column).is(params));
        return this;
    }

    public CriteriaWrapper ne(String column, Object params) {
        this.list.add(Criteria.where((String)column).ne(params));
        return this;
    }

    public CriteriaWrapper lt(String column, Object params) {
        this.list.add(Criteria.where((String)column).lt(params));
        return this;
    }

    public CriteriaWrapper lte(String column, Object params) {
        this.list.add(Criteria.where((String)column).lte(params));
        return this;
    }

    public CriteriaWrapper gt(String column, Object params) {
        this.list.add(Criteria.where((String)column).gt(params));
        return this;
    }

    public CriteriaWrapper gte(String column, Object params) {
        this.list.add(Criteria.where((String)column).gte(params));
        return this;
    }

    public CriteriaWrapper contain(String column, Object params) {
        this.list.add(Criteria.where((String)column).all(new Object[]{params}));
        return this;
    }

    public CriteriaWrapper containOr(String column, Collection<?> params) {
        CriteriaOrWrapper criteriaOrWrapper = new CriteriaOrWrapper();
        for (Object object : params) {
            criteriaOrWrapper.contain(column, object);
        }
        this.list.add(criteriaOrWrapper.build());
        return this;
    }

    public CriteriaWrapper containOr(String column, Object[] params) {
        return this.containOr(column, Arrays.asList(params));
    }

    public CriteriaWrapper containAnd(String column, Collection<?> params) {
        this.list.add(Criteria.where((String)column).all(params));
        return this;
    }

    public CriteriaWrapper containAnd(String column, Object[] params) {
        return this.containAnd(column, Arrays.asList(params));
    }

    public CriteriaWrapper like(String column, String params) {
        Pattern pattern = Pattern.compile("^.*" + params + ".*$", 2);
        this.list.add(Criteria.where((String)column).regex(pattern));
        return this;
    }

    public CriteriaWrapper in(String column, Collection<?> params) {
        this.list.add(Criteria.where((String)column).in(params));
        return this;
    }

    public CriteriaWrapper in(String column, Object[] params) {
        return this.in(column, Arrays.asList(params));
    }

    public CriteriaWrapper nin(String column, Collection<?> params) {
        this.list.add(Criteria.where((String)column).nin(params));
        return this;
    }

    public CriteriaWrapper nin(String column, Object[] params) {
        return this.nin(column, Arrays.asList(params));
    }

    public CriteriaWrapper isNull(String column) {
        this.list.add(Criteria.where((String)column).is(null));
        return this;
    }

    public CriteriaWrapper isNotNull(String column) {
        this.list.add(Criteria.where((String)column).ne(null));
        return this;
    }
}

