//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.response;

import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Boolean;
import java.lang.String;
import java.util.Date;

/**
 * 权益核销接口
 * 分成两种模式:
 * 1 notice 被动接受核销结果通知
 * 2. pay 主动进行权益核销 */
public class ExecRightsPayResponse extends AntCloudProdResponse {
  private String extResultInfo;

  private Boolean needRetry;

  private String outTradeNo;

  private Boolean tradeResult;

  private Date tradeTime;

  /**
   * 扩展结果字段 */
  public String getExtResultInfo() {
    return this.extResultInfo;
  }

  /**
   * 扩展结果字段 */
  public void setExtResultInfo(String extResultInfo) {
    this.extResultInfo = extResultInfo;
  }

  /**
   * 是否需要重试 */
  public Boolean getNeedRetry() {
    return this.needRetry;
  }

  /**
   * 是否需要重试 */
  public void setNeedRetry(Boolean needRetry) {
    this.needRetry = needRetry;
  }

  /**
   * 外部流水号 */
  public String getOutTradeNo() {
    return this.outTradeNo;
  }

  /**
   * 外部流水号 */
  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  /**
   * 交易结果
   * 当payType == pay时,表示核销结果 */
  public Boolean getTradeResult() {
    return this.tradeResult;
  }

  /**
   * 交易结果
   * 当payType == pay时,表示核销结果 */
  public void setTradeResult(Boolean tradeResult) {
    this.tradeResult = tradeResult;
  }

  /**
   * 交易时间 */
  public Date getTradeTime() {
    return this.tradeTime;
  }

  /**
   * 交易时间 */
  public void setTradeTime(Date tradeTime) {
    this.tradeTime = tradeTime;
  }
}
