//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.CheckService;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.LogConfig;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.LogIndex;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.UpdateServerlessappserviceResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 修改应用实例
 */
public class UpdateServerlessappserviceRequest extends AntCloudProviderRequest<UpdateServerlessappserviceResponse> {
  private CheckService checkService;

  private String description;

  private List<String> externalDomains;

  private List<String> internalDomains;

  private LogConfig logConfig;

  private LogIndex logIndex;

  private String logProject;

  private String logStore;

  private String logTenant;

  private String maxAverageCpuUtilizationPercent;

  private String maxAverageMemUtilizationPercent;

  private Long maxComputeInstance;

  private Long maxResponseTimeInMs;

  private String minAverageCpuUtilizationPercent;

  private String minAverageMemUtilizationPercent;

  private Long minResponseTimeInMs;

  @NotNull
  private String name;

  private Long reservedComputeInstance;

  private Boolean shared;

  @NotNull
  private String workspace;

  public UpdateServerlessappserviceRequest() {
    super("antcloud.sas.serverlessappservice.update", "1.0", "Java-SDK-20190410");
  }

  /**
   * 健康检查 */
  public CheckService getCheckService() {
    return this.checkService;
  }

  /**
   * 健康检查 */
  public void setCheckService(CheckService checkService) {
    this.checkService = checkService;
  }

  /**
   * 应用实例描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 应用实例描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 选填，应用服务的公网域名，域名需自行额外注册，可修改 */
  public List<String> getExternalDomains() {
    return this.externalDomains;
  }

  /**
   * 选填，应用服务的公网域名，域名需自行额外注册，可修改 */
  public void setExternalDomains(List<String> externalDomains) {
    this.externalDomains = externalDomains;
  }

  /**
   * 选填，应用服务的内网域名，可供服务间调用，可修改 */
  public List<String> getInternalDomains() {
    return this.internalDomains;
  }

  /**
   * 选填，应用服务的内网域名，可供服务间调用，可修改 */
  public void setInternalDomains(List<String> internalDomains) {
    this.internalDomains = internalDomains;
  }

  /**
   * 日志配置 */
  public LogConfig getLogConfig() {
    return this.logConfig;
  }

  /**
   * 日志配置 */
  public void setLogConfig(LogConfig logConfig) {
    this.logConfig = logConfig;
  }

  /**
   * 索引 */
  public LogIndex getLogIndex() {
    return this.logIndex;
  }

  /**
   * 索引 */
  public void setLogIndex(LogIndex logIndex) {
    this.logIndex = logIndex;
  }

  /**
   * myproj */
  public String getLogProject() {
    return this.logProject;
  }

  /**
   * myproj */
  public void setLogProject(String logProject) {
    this.logProject = logProject;
  }

  /**
   * mystore */
  public String getLogStore() {
    return this.logStore;
  }

  /**
   * mystore */
  public void setLogStore(String logStore) {
    this.logStore = logStore;
  }

  /**
   * 日志租户 */
  public String getLogTenant() {
    return this.logTenant;
  }

  /**
   * 日志租户 */
  public void setLogTenant(String logTenant) {
    this.logTenant = logTenant;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public String getMaxAverageCpuUtilizationPercent() {
    return this.maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxAverageCpuUtilizationPercent(String maxAverageCpuUtilizationPercent) {
    this.maxAverageCpuUtilizationPercent = maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public String getMaxAverageMemUtilizationPercent() {
    return this.maxAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxAverageMemUtilizationPercent(String maxAverageMemUtilizationPercent) {
    this.maxAverageMemUtilizationPercent = maxAverageMemUtilizationPercent;
  }

  /**
   * 各个版本同时运行的最大计算实例 */
  public Long getMaxComputeInstance() {
    return this.maxComputeInstance;
  }

  /**
   * 各个版本同时运行的最大计算实例 */
  public void setMaxComputeInstance(Long maxComputeInstance) {
    this.maxComputeInstance = maxComputeInstance;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public Long getMaxResponseTimeInMs() {
    return this.maxResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxResponseTimeInMs(Long maxResponseTimeInMs) {
    this.maxResponseTimeInMs = maxResponseTimeInMs;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public String getMinAverageCpuUtilizationPercent() {
    return this.minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinAverageCpuUtilizationPercent(String minAverageCpuUtilizationPercent) {
    this.minAverageCpuUtilizationPercent = minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public String getMinAverageMemUtilizationPercent() {
    return this.minAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinAverageMemUtilizationPercent(String minAverageMemUtilizationPercent) {
    this.minAverageMemUtilizationPercent = minAverageMemUtilizationPercent;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public Long getMinResponseTimeInMs() {
    return this.minResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinResponseTimeInMs(Long minResponseTimeInMs) {
    this.minResponseTimeInMs = minResponseTimeInMs;
  }

  /**
   * 应用实例名称（不可修改） */
  public String getName() {
    return this.name;
  }

  /**
   * 应用实例名称（不可修改） */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 保留计算实例 */
  public Long getReservedComputeInstance() {
    return this.reservedComputeInstance;
  }

  /**
   * 保留计算实例 */
  public void setReservedComputeInstance(Long reservedComputeInstance) {
    this.reservedComputeInstance = reservedComputeInstance;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * workspace */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * workspace */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
