//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.CheckService;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.CodePackage;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.EnvironmentVariable;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.VersionRouteInfo;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.CreateServerlessappserviceVersionResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 创建应用实例版本
 */
public class CreateServerlessappserviceVersionRequest extends AntCloudProviderRequest<CreateServerlessappserviceVersionResponse> {
  @NotNull
  private String appServiceName;

  @NotNull
  private String buildMode;

  private CheckService checkService;

  private String codeImageUrl;

  private CodePackage codePackage;

  private Long cpuOversoldRatio;

  private List<EnvironmentVariable> customVariables;

  private String description;

  private String entryPoint;

  private String executionMode;

  private Long expiredAfter;

  @NotNull
  private String fullVersion;

  private Boolean isAllTrafficToThisVersion;

  private String maxAverageCpuUtilizationPercent;

  private String maxAverageMemUtilizationPercent;

  private Long maxComputeInstance;

  private Long maxConcurrencyPerInstance;

  private Long maxResponseTimeInMs;

  private String minAverageCpuUtilizationPercent;

  private String minAverageMemUtilizationPercent;

  private Long minComputeInstance;

  private Long minResponseTimeInMs;

  private Long routeWeight;

  private String runtimeIdentity;

  private List<EnvironmentVariable> runtimeVariables;

  private Long servicePort;

  private Boolean shared;

  @NotNull
  private String specIdentity;

  private List<VersionRouteInfo> versionRouteInfos;

  @NotNull
  private String workspace;

  public CreateServerlessappserviceVersionRequest() {
    super("antcloud.sas.serverlessappservice.version.create", "1.0", "Java-SDK-20190410");
  }

  /**
   * 应用实例名称 */
  public String getAppServiceName() {
    return this.appServiceName;
  }

  /**
   * 应用实例名称 */
  public void setAppServiceName(String appServiceName) {
    this.appServiceName = appServiceName;
  }

  /**
   * 构建模式，枚举，取值如下：
   * IMAGE：镜像模式运行
   * CODE_PACKAGE：代码包模式运行
   * 创建后不可修改 */
  public String getBuildMode() {
    return this.buildMode;
  }

  /**
   * 构建模式，枚举，取值如下：
   * IMAGE：镜像模式运行
   * CODE_PACKAGE：代码包模式运行
   * 创建后不可修改 */
  public void setBuildMode(String buildMode) {
    this.buildMode = buildMode;
  }

  /**
   * 服务检查 */
  public CheckService getCheckService() {
    return this.checkService;
  }

  /**
   * 服务检查 */
  public void setCheckService(CheckService checkService) {
    this.checkService = checkService;
  }

  /**
   * 构建模式是镜像模式时, 镜像在aks上的地址. 
   * 用户需要先将镜像上传到aks上
   */
  public String getCodeImageUrl() {
    return this.codeImageUrl;
  }

  /**
   * 构建模式是镜像模式时, 镜像在aks上的地址. 
   * 用户需要先将镜像上传到aks上
   */
  public void setCodeImageUrl(String codeImageUrl) {
    this.codeImageUrl = codeImageUrl;
  }

  /**
   * 代码包. 
   * 如果应用实例的构建模式是代码包, 那么code_package必须传. 
   */
  public CodePackage getCodePackage() {
    return this.codePackage;
  }

  /**
   * 代码包. 
   * 如果应用实例的构建模式是代码包, 那么code_package必须传. 
   */
  public void setCodePackage(CodePackage codePackage) {
    this.codePackage = codePackage;
  }

  /**
   * cpu超卖比, 默认为1 */
  public Long getCpuOversoldRatio() {
    return this.cpuOversoldRatio;
  }

  /**
   * cpu超卖比, 默认为1 */
  public void setCpuOversoldRatio(Long cpuOversoldRatio) {
    this.cpuOversoldRatio = cpuOversoldRatio;
  }

  /**
   * 自定义环境信息.
   * 要填name value description信息 */
  public List<EnvironmentVariable> getCustomVariables() {
    return this.customVariables;
  }

  /**
   * 自定义环境信息.
   * 要填name value description信息 */
  public void setCustomVariables(List<EnvironmentVariable> customVariables) {
    this.customVariables = customVariables;
  }

  /**
   * 版本描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 版本描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 当构建模式是代码包时需要.
   * 代表加载的代码入口 */
  public String getEntryPoint() {
    return this.entryPoint;
  }

  /**
   * 当构建模式是代码包时需要.
   * 代表加载的代码入口 */
  public void setEntryPoint(String entryPoint) {
    this.entryPoint = entryPoint;
  }

  /**
   * 如果应用实例的构建模式 是代码包时必填.
   * 代表代码包的运行模式
   * 取值如下:
   * SERVICE是服务端运行模式;
   * FUNCTION是纯函数运行模式 */
  public String getExecutionMode() {
    return this.executionMode;
  }

  /**
   * 如果应用实例的构建模式 是代码包时必填.
   * 代表代码包的运行模式
   * 取值如下:
   * SERVICE是服务端运行模式;
   * FUNCTION是纯函数运行模式 */
  public void setExecutionMode(String executionMode) {
    this.executionMode = executionMode;
  }

  /**
   * 该版本流量比为0时过多久会自动删除. 
   * 单位为小时.
   * 默认为一周, 168小时 */
  public Long getExpiredAfter() {
    return this.expiredAfter;
  }

  /**
   * 该版本流量比为0时过多久会自动删除. 
   * 单位为小时.
   * 默认为一周, 168小时 */
  public void setExpiredAfter(Long expiredAfter) {
    this.expiredAfter = expiredAfter;
  }

  /**
   * 版本号 */
  public String getFullVersion() {
    return this.fullVersion;
  }

  /**
   * 版本号 */
  public void setFullVersion(String fullVersion) {
    this.fullVersion = fullVersion;
  }

  /**
   * 是否新版本的流量比是100% */
  public Boolean getIsAllTrafficToThisVersion() {
    return this.isAllTrafficToThisVersion;
  }

  /**
   * 是否新版本的流量比是100% */
  public void setIsAllTrafficToThisVersion(Boolean isAllTrafficToThisVersion) {
    this.isAllTrafficToThisVersion = isAllTrafficToThisVersion;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public String getMaxAverageCpuUtilizationPercent() {
    return this.maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxAverageCpuUtilizationPercent(String maxAverageCpuUtilizationPercent) {
    this.maxAverageCpuUtilizationPercent = maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public String getMaxAverageMemUtilizationPercent() {
    return this.maxAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxAverageMemUtilizationPercent(String maxAverageMemUtilizationPercent) {
    this.maxAverageMemUtilizationPercent = maxAverageMemUtilizationPercent;
  }

  /**
   * 该版本的最大实例数 */
  public Long getMaxComputeInstance() {
    return this.maxComputeInstance;
  }

  /**
   * 该版本的最大实例数 */
  public void setMaxComputeInstance(Long maxComputeInstance) {
    this.maxComputeInstance = maxComputeInstance;
  }

  /**
   * 单实例最大并发度 */
  public Long getMaxConcurrencyPerInstance() {
    return this.maxConcurrencyPerInstance;
  }

  /**
   * 单实例最大并发度 */
  public void setMaxConcurrencyPerInstance(Long maxConcurrencyPerInstance) {
    this.maxConcurrencyPerInstance = maxConcurrencyPerInstance;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public Long getMaxResponseTimeInMs() {
    return this.maxResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxResponseTimeInMs(Long maxResponseTimeInMs) {
    this.maxResponseTimeInMs = maxResponseTimeInMs;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public String getMinAverageCpuUtilizationPercent() {
    return this.minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinAverageCpuUtilizationPercent(String minAverageCpuUtilizationPercent) {
    this.minAverageCpuUtilizationPercent = minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public String getMinAverageMemUtilizationPercent() {
    return this.minAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinAverageMemUtilizationPercent(String minAverageMemUtilizationPercent) {
    this.minAverageMemUtilizationPercent = minAverageMemUtilizationPercent;
  }

  /**
   * 版本最小实例数 */
  public Long getMinComputeInstance() {
    return this.minComputeInstance;
  }

  /**
   * 版本最小实例数 */
  public void setMinComputeInstance(Long minComputeInstance) {
    this.minComputeInstance = minComputeInstance;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public Long getMinResponseTimeInMs() {
    return this.minResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinResponseTimeInMs(Long minResponseTimeInMs) {
    this.minResponseTimeInMs = minResponseTimeInMs;
  }

  /**
   * 设置历史版本的流量权重 */
  public Long getRouteWeight() {
    return this.routeWeight;
  }

  /**
   * 设置历史版本的流量权重 */
  public void setRouteWeight(Long routeWeight) {
    this.routeWeight = routeWeight;
  }

  /**
   * 使用的运行时标识
   * 应用实例的构建模式为代码包时必填 */
  public String getRuntimeIdentity() {
    return this.runtimeIdentity;
  }

  /**
   * 使用的运行时标识
   * 应用实例的构建模式为代码包时必填 */
  public void setRuntimeIdentity(String runtimeIdentity) {
    this.runtimeIdentity = runtimeIdentity;
  }

  /**
   * 运行时环境变量
   * 要填name, value信息 */
  public List<EnvironmentVariable> getRuntimeVariables() {
    return this.runtimeVariables;
  }

  /**
   * 运行时环境变量
   * 要填name, value信息 */
  public void setRuntimeVariables(List<EnvironmentVariable> runtimeVariables) {
    this.runtimeVariables = runtimeVariables;
  }

  /**
   * 公网域名转发到的后端pod端口. 
   * 运行模式是SERVICE模式需要 */
  public Long getServicePort() {
    return this.servicePort;
  }

  /**
   * 公网域名转发到的后端pod端口. 
   * 运行模式是SERVICE模式需要 */
  public void setServicePort(Long servicePort) {
    this.servicePort = servicePort;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * 使用的规格标识 */
  public String getSpecIdentity() {
    return this.specIdentity;
  }

  /**
   * 使用的规格标识 */
  public void setSpecIdentity(String specIdentity) {
    this.specIdentity = specIdentity;
  }

  /**
   * 历史版本权重信息 */
  public List<VersionRouteInfo> getVersionRouteInfos() {
    return this.versionRouteInfos;
  }

  /**
   * 历史版本权重信息 */
  public void setVersionRouteInfos(List<VersionRouteInfo> versionRouteInfos) {
    this.versionRouteInfos = versionRouteInfos;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
