//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.CheckService;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.LogConfig;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.LogIndex;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.CreateServerlessappserviceResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 在workspace维度创建应用服务实例
 */
public class CreateServerlessappserviceRequest extends AntCloudProviderRequest<CreateServerlessappserviceResponse> {
  @NotNull
  private String appName;

  private CheckService checkService;

  private String cluster;

  private String creatorId;

  private String customLogProject;

  private String customLogStore;

  private String customLogTenant;

  private String description;

  private List<String> externalDomains;

  private List<String> internalDomains;

  private LogConfig logConfig;

  private LogIndex logIndex;

  private String maxAverageCpuUtilizationPercent;

  private String maxAverageMemUtilizationPercent;

  private Long maxComputeInstance;

  private Long maxResponseTimeInMs;

  private String minAverageCpuUtilizationPercent;

  private String minAverageMemUtilizationPercent;

  private Long minResponseTimeInMs;

  @NotNull
  private String name;

  private Long reservedComputeInstance;

  private Boolean shared;

  @NotNull
  private String workspace;

  public CreateServerlessappserviceRequest() {
    super("antcloud.sas.serverlessappservice.create", "1.0", "Java-SDK-20190410");
  }

  /**
   * 应用的名称，租户唯一
   */
  public String getAppName() {
    return this.appName;
  }

  /**
   * 应用的名称，租户唯一
   */
  public void setAppName(String appName) {
    this.appName = appName;
  }

  /**
   * 健康检查 */
  public CheckService getCheckService() {
    return this.checkService;
  }

  /**
   * 健康检查 */
  public void setCheckService(CheckService checkService) {
    this.checkService = checkService;
  }

  /**
   * cluster */
  public String getCluster() {
    return this.cluster;
  }

  /**
   * cluster */
  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  /**
   * 应用实例的创建人ID（用户ID)  */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 应用实例的创建人ID（用户ID)  */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 自定义log project */
  public String getCustomLogProject() {
    return this.customLogProject;
  }

  /**
   * 自定义log project */
  public void setCustomLogProject(String customLogProject) {
    this.customLogProject = customLogProject;
  }

  /**
   * 自定义log仓库 */
  public String getCustomLogStore() {
    return this.customLogStore;
  }

  /**
   * 自定义log仓库 */
  public void setCustomLogStore(String customLogStore) {
    this.customLogStore = customLogStore;
  }

  /**
   * 日志租户 */
  public String getCustomLogTenant() {
    return this.customLogTenant;
  }

  /**
   * 日志租户 */
  public void setCustomLogTenant(String customLogTenant) {
    this.customLogTenant = customLogTenant;
  }

  /**
   * 应用实例的描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 应用实例的描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 参考 ServerlessAppService 定义 */
  public List<String> getExternalDomains() {
    return this.externalDomains;
  }

  /**
   * 参考 ServerlessAppService 定义 */
  public void setExternalDomains(List<String> externalDomains) {
    this.externalDomains = externalDomains;
  }

  /**
   * example.com */
  public List<String> getInternalDomains() {
    return this.internalDomains;
  }

  /**
   * example.com */
  public void setInternalDomains(List<String> internalDomains) {
    this.internalDomains = internalDomains;
  }

  /**
   * 日志采集配置 */
  public LogConfig getLogConfig() {
    return this.logConfig;
  }

  /**
   * 日志采集配置 */
  public void setLogConfig(LogConfig logConfig) {
    this.logConfig = logConfig;
  }

  /**
   * 日志索引配置 */
  public LogIndex getLogIndex() {
    return this.logIndex;
  }

  /**
   * 日志索引配置 */
  public void setLogIndex(LogIndex logIndex) {
    this.logIndex = logIndex;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public String getMaxAverageCpuUtilizationPercent() {
    return this.maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxAverageCpuUtilizationPercent(String maxAverageCpuUtilizationPercent) {
    this.maxAverageCpuUtilizationPercent = maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public String getMaxAverageMemUtilizationPercent() {
    return this.maxAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxAverageMemUtilizationPercent(String maxAverageMemUtilizationPercent) {
    this.maxAverageMemUtilizationPercent = maxAverageMemUtilizationPercent;
  }

  /**
   * 每个租户实际同时运行的计算实例数不能超过500
   * 默认为500 */
  public Long getMaxComputeInstance() {
    return this.maxComputeInstance;
  }

  /**
   * 每个租户实际同时运行的计算实例数不能超过500
   * 默认为500 */
  public void setMaxComputeInstance(Long maxComputeInstance) {
    this.maxComputeInstance = maxComputeInstance;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public Long getMaxResponseTimeInMs() {
    return this.maxResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改 */
  public void setMaxResponseTimeInMs(Long maxResponseTimeInMs) {
    this.maxResponseTimeInMs = maxResponseTimeInMs;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public String getMinAverageCpuUtilizationPercent() {
    return this.minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinAverageCpuUtilizationPercent(String minAverageCpuUtilizationPercent) {
    this.minAverageCpuUtilizationPercent = minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public String getMinAverageMemUtilizationPercent() {
    return this.minAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinAverageMemUtilizationPercent(String minAverageMemUtilizationPercent) {
    this.minAverageMemUtilizationPercent = minAverageMemUtilizationPercent;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public Long getMinResponseTimeInMs() {
    return this.minResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改 */
  public void setMinResponseTimeInMs(Long minResponseTimeInMs) {
    this.minResponseTimeInMs = minResponseTimeInMs;
  }

  /**
   * 生成的应用实例的名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 生成的应用实例的名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 设置保留计算实例可以确保所有应用业务量较大时，始终保障当前应用服务实例可以使用特定数量的计算实例
   * 默认为0 */
  public Long getReservedComputeInstance() {
    return this.reservedComputeInstance;
  }

  /**
   * 设置保留计算实例可以确保所有应用业务量较大时，始终保障当前应用服务实例可以使用特定数量的计算实例
   * 默认为0 */
  public void setReservedComputeInstance(Long reservedComputeInstance) {
    this.reservedComputeInstance = reservedComputeInstance;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群
   * 如果是共享集群, 则需要填写cluster
   * 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
