//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Long;
import java.lang.String;

/**
 * 版本路由权重信息 */
public class VersionRouteInfo {
  private String appServiceFullVersion;

  private String appServiceName;

  private String description;

  private Long percent;

  private String runtimeFullVersion;

  private String runtimeIdentity;

  private String techstackIdentity;

  private String techstackName;

  private Long weight;

  /**
   * 应用服务版本，创建后不可修改，必填，0 - 50 */
  public String getAppServiceFullVersion() {
    return this.appServiceFullVersion;
  }

  /**
   * 应用服务版本，创建后不可修改，必填，0 - 50 */
  public void setAppServiceFullVersion(String appServiceFullVersion) {
    this.appServiceFullVersion = appServiceFullVersion;
  }

  /**
   * 服务实例名称 */
  public String getAppServiceName() {
    return this.appServiceName;
  }

  /**
   * 服务实例名称 */
  public void setAppServiceName(String appServiceName) {
    this.appServiceName = appServiceName;
  }

  /**
   * 版本描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 版本描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 表示版本的流量百分比. 范围0-100. 比如如果流量比是60%, 那么percent值为60.
   */
  public Long getPercent() {
    return this.percent;
  }

  /**
   * 表示版本的流量百分比. 范围0-100. 比如如果流量比是60%, 那么percent值为60.
   */
  public void setPercent(Long percent) {
    this.percent = percent;
  }

  /**
   * 1.8.3 */
  public String getRuntimeFullVersion() {
    return this.runtimeFullVersion;
  }

  /**
   * 1.8.3 */
  public void setRuntimeFullVersion(String runtimeFullVersion) {
    this.runtimeFullVersion = runtimeFullVersion;
  }

  /**
   * 版本使用的运行时标识 */
  public String getRuntimeIdentity() {
    return this.runtimeIdentity;
  }

  /**
   * 版本使用的运行时标识 */
  public void setRuntimeIdentity(String runtimeIdentity) {
    this.runtimeIdentity = runtimeIdentity;
  }

  /**
   * 技术栈标识，从版本中冗余，只读 */
  public String getTechstackIdentity() {
    return this.techstackIdentity;
  }

  /**
   * 技术栈标识，从版本中冗余，只读 */
  public void setTechstackIdentity(String techstackIdentity) {
    this.techstackIdentity = techstackIdentity;
  }

  /**
   * 技术栈名称，从版本中冗余，只读 */
  public String getTechstackName() {
    return this.techstackName;
  }

  /**
   * 技术栈名称，从版本中冗余，只读 */
  public void setTechstackName(String techstackName) {
    this.techstackName = techstackName;
  }

  /**
   * 权重信息 */
  public Long getWeight() {
    return this.weight;
  }

  /**
   * 权重信息 */
  public void setWeight(Long weight) {
    this.weight = weight;
  }
}
