/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.sponge7;

import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.meta.SimpleCommandMeta;
import cloud.commandframework.sponge7.SpongePluginRegistrationHandler;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.plugin.PluginContainer;

@Singleton
public class SpongeCommandManager<C>
extends CommandManager<C> {
    private final PluginContainer owningPlugin;
    private final Function<CommandSource, C> forwardMapper;
    private final Function<C, CommandSource> reverseMapper;

    @Inject
    public SpongeCommandManager(@NonNull PluginContainer container, @NonNull Function<CommandTree<C>, CommandExecutionCoordinator<C>> commandExecutionCoordinator, Function<CommandSource, C> forwardMapper, Function<C, CommandSource> reverseMapper) {
        super(commandExecutionCoordinator, new SpongePluginRegistrationHandler());
        this.owningPlugin = Objects.requireNonNull(container, "container");
        this.forwardMapper = Objects.requireNonNull(forwardMapper, "forwardMapper");
        this.reverseMapper = Objects.requireNonNull(reverseMapper, "reverseMapper");
        ((SpongePluginRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
    }

    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return this.reverseMapper.apply(sender).hasPermission(permission);
    }

    public final @NonNull CommandMeta createDefaultCommandMeta() {
        return SimpleCommandMeta.empty();
    }

    public @NonNull Function<CommandSource, C> getCommandSourceMapper() {
        return this.forwardMapper;
    }

    public final @NonNull Function<C, CommandSource> getReverseCommandSourceMapper() {
        return this.reverseMapper;
    }

    final PluginContainer getOwningPlugin() {
        return this.owningPlugin;
    }
}

