/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.ehcache;

import cloud.agileframework.cache.support.AbstractAgileCacheManager;
import cloud.agileframework.cache.support.ehcache.AgileEhCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.event.CacheEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;

public class AgileEhCacheCacheManager
extends AbstractAgileCacheManager {
    private CacheManager cacheManager;
    private CacheEventListener syncCacheEventListener;
    private static final ConcurrentMap<String, AgileEhCache> CACHE_MAP = new ConcurrentHashMap<String, AgileEhCache>();

    public AgileEhCacheCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Autowired
    public void setSyncCacheEventListener(CacheEventListener syncCacheEventListener) {
        this.syncCacheEventListener = syncCacheEventListener;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public AgileEhCache cover(Cache cache) {
        return new AgileEhCache((EhCacheCache)cache);
    }

    @Override
    public AgileEhCache getMissingCache(String cacheName) {
        assert (this.cacheManager != null);
        Ehcache target = this.cacheManager.getEhcache(cacheName);
        if (target == null) {
            target = this.cacheManager.addCacheIfAbsent(cacheName);
        }
        return this.cover((Cache)new EhCacheCache(target));
    }

    @Override
    public AgileEhCache getCache(String cacheName) {
        AgileEhCache cache = (AgileEhCache)CACHE_MAP.get(cacheName);
        if (cache == null) {
            cache = this.getMissingCache(cacheName);
            CACHE_MAP.putIfAbsent(cacheName, cache);
            cache.getNativeCache().getCacheEventNotificationService().registerListener(this.syncCacheEventListener);
        }
        return cache;
    }
}

