/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.redis;

import cloud.agileframework.cache.support.AbstractAgileCacheManager;
import cloud.agileframework.cache.support.redis.AgileRedis;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class AgileRedisCacheManager
extends AbstractAgileCacheManager {
    private RedisCacheManager cacheManager;
    private final RedisConnectionFactory redisConnectionFactory;
    private final ConcurrentMap<String, AgileRedis> CACHE_MAP = new ConcurrentHashMap<String, AgileRedis>();

    public AgileRedisCacheManager(RedisCacheManager cacheManager, RedisConnectionFactory redisConnectionFactory) {
        this.setCacheManager(cacheManager);
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public RedisCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(RedisCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public AgileRedis cover(Cache cache) {
        return new AgileRedis((RedisCache)cache, this.redisConnectionFactory);
    }

    @Override
    public AgileRedis getMissingCache(String cacheName) {
        return this.cover(this.cacheManager.getCache(cacheName));
    }

    @Override
    public AgileRedis getCache(String cacheName) {
        AgileRedis cache = (AgileRedis)this.CACHE_MAP.get(cacheName);
        if (cache == null) {
            cache = this.getMissingCache(cacheName);
            this.CACHE_MAP.putIfAbsent(cacheName, cache);
        }
        return cache;
    }
}

