/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.ehcache;

import cloud.agileframework.cache.support.ehcache.TransmitKey;
import cloud.agileframework.cache.sync.OpType;
import cloud.agileframework.cache.sync.SyncCache;
import cloud.agileframework.cache.sync.SyncKeys;
import cloud.agileframework.cache.util.BeanUtil;
import java.time.Duration;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListenerAdapter;

public class SyncCacheEventListener
extends CacheEventListenerAdapter {
    private SyncCache syncCache;

    public SyncCache getSyncCache() {
        if (this.syncCache == null) {
            this.syncCache = (SyncCache)BeanUtil.getApplicationContext().getBean(SyncCache.class);
        }
        return this.syncCache;
    }

    private boolean needSync(Element element) {
        Object key = element.getObjectKey();
        return this.keyNeedSync(key);
    }

    private boolean keyNeedSync(Object key) {
        return !(key instanceof TransmitKey) || !((TransmitKey)key).isTransmit();
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.needSync(element)) {
            return;
        }
        this.getSyncCache().sync(this.getSyncKeys(cache, element), OpType.DELETE);
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.needSync(element)) {
            return;
        }
        this.getSyncCache().sync(this.getSyncKeys(cache, element), OpType.WRITE);
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.needSync(element)) {
            return;
        }
        this.getSyncCache().sync(this.getSyncKeys(cache, element), OpType.WRITE);
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (this.needSync(element)) {
            return;
        }
        this.getSyncCache().sync(this.getSyncKeys(cache, element), OpType.DELETE);
    }

    public void notifyRemoveAll(Ehcache cache) {
        List keys = cache.getKeys();
        for (Object key : keys) {
            if (this.keyNeedSync(key)) {
                return;
            }
            this.getSyncCache().sync(SyncKeys.of(cache.getName(), key), OpType.DELETE);
        }
    }

    private SyncKeys getSyncKeys(Ehcache cache, Element element) {
        if (element.getTimeToLive() == 0) {
            return SyncKeys.of(cache.getName(), element.getObjectKey());
        }
        long millis = element.getExpirationTime() - System.currentTimeMillis();
        if (millis > 0L) {
            return SyncKeys.of(cache.getName(), element.getObjectKey(), Duration.ofMillis(millis));
        }
        return SyncKeys.of(cache.getName(), element.getObjectKey(), Duration.ofMillis(0L));
    }
}

