/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.config;

import cloud.agileframework.cache.config.CacheAutoConfiguration;
import cloud.agileframework.cache.config.RedisAutoConfiguration;
import cloud.agileframework.cache.properties.EhCacheProperties;
import cloud.agileframework.cache.support.ehcache.AgileEhCacheCacheManager;
import cloud.agileframework.cache.support.ehcache.SyncCacheEventListener;
import cloud.agileframework.cache.support.redis.AgileRedisCacheManager;
import cloud.agileframework.cache.sync.RedisSyncCache;
import cloud.agileframework.cache.sync.SyncCache;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={EhCacheProperties.class})
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnProperty(name={"enabled"}, prefix="spring.ehcache", matchIfMissing=true)
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class EhCacheAutoConfiguration
implements CacheAutoConfiguration {
    @Autowired
    private EhCacheProperties ehCacheProperties;

    @Bean
    @Primary
    public AgileEhCacheCacheManager agileEhCacheCacheManager(CacheManager ehCacheCacheManager) {
        return new AgileEhCacheCacheManager(ehCacheCacheManager);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    public CacheManager ehCacheCacheManager() {
        return new CacheManager(this.configuration());
    }

    public net.sf.ehcache.config.Configuration configuration() {
        DiskStoreConfiguration diskStoreConfiguration = new DiskStoreConfiguration().path(this.ehCacheProperties.getPath());
        net.sf.ehcache.config.Configuration configuration = new net.sf.ehcache.config.Configuration().diskStore(diskStoreConfiguration);
        configuration.setName(this.ehCacheProperties.getDefaultConfigName());
        Map<String, CacheConfiguration> regions = this.ehCacheProperties.getRegions();
        for (Map.Entry<String, CacheConfiguration> entry : regions.entrySet()) {
            String name = entry.getKey();
            CacheConfiguration regionConfig = entry.getValue();
            regionConfig.setName(name);
            if (this.ehCacheProperties.getDefaultConfigName().equals(name)) {
                configuration.setDefaultCacheConfiguration(regionConfig);
                configuration.cache(regionConfig.clone().name("hibernate.org.hibernate.cache.spi.TimestampsRegion"));
                configuration.cache(regionConfig.clone().name("hibernate.org.hibernate.cache.spi.QueryResultsRegion"));
                continue;
            }
            configuration.cache(regionConfig);
        }
        return configuration;
    }

    @Bean
    @ConditionalOnBean(value={AgileRedisCacheManager.class})
    @ConditionalOnProperty(name={"sync"}, prefix="spring.ehcache")
    public RedisSyncCache syncCache() {
        return new RedisSyncCache();
    }

    @Bean
    @ConditionalOnMissingBean(value={SyncCache.class})
    public SyncCache syncCacheDefault() {
        return new SyncCache(){};
    }

    @Bean
    @ConditionalOnBean(value={SyncCache.class})
    public SyncCacheEventListener syncCacheEventListener() {
        return new SyncCacheEventListener();
    }
}

