/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.config;

import cloud.agileframework.cache.config.CacheAutoConfiguration;
import cloud.agileframework.cache.config.EhCacheAutoConfiguration;
import cloud.agileframework.cache.config.RedisAutoConfiguration;
import cloud.agileframework.cache.support.AgileCacheManagerInterface;
import cloud.agileframework.cache.support.memory.MemoryCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CacheProperties.class})
@AutoConfigureAfter(value={EhCacheAutoConfiguration.class, RedisAutoConfiguration.class})
public class MemoryCacheAutoConfiguration
extends CacheAutoConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheProperties cacheProperties;

    @Override
    @Bean
    @ConditionalOnMissingBean(value={AgileCacheManagerInterface.class})
    public MemoryCacheManager agileCacheManager() {
        if (CacheType.REDIS == this.cacheProperties.getType() || CacheType.EHCACHE == this.cacheProperties.getType()) {
            this.log.error("\u68c0\u6d4b\u5230\u60a8\u6240\u914d\u7f6e\u7684\u7f13\u5b58\u4ecb\u8d28\uff0c\u751f\u6210\u6761\u4ef6\u65e0\u6cd5\u6ee1\u8db3\uff0c\u5df2\u542f\u7528\u9ed8\u8ba4\u7684\u5185\u5b58\u7f13\u5b58\u4ecb\u8d28");
        }
        return new MemoryCacheManager();
    }
}

