/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.sync;

import cloud.agileframework.cache.sync.CacheSyncException;
import cloud.agileframework.cache.sync.SyncCache;
import cloud.agileframework.cache.sync.SyncKeys;
import com.google.common.collect.Maps;
import java.util.Map;

public abstract class AbstractSyncCache
implements SyncCache {
    private static final Map<String, SyncKeys> KEY_INFO = Maps.newConcurrentMap();
    private static final Map<String, SyncKeys> CHANNEL_KEY_INFO = Maps.newConcurrentMap();

    AbstractSyncCache() {
    }

    private static void initKeys(String region, String key) {
        SyncKeys syncKeys = SyncKeys.builder().region(region).channel(key + "_channel").data(key).version(key + "_version").readLock(key + "_readLock").writeLock(key + "_writeLock").build();
        KEY_INFO.put(region + key, syncKeys);
        CHANNEL_KEY_INFO.put(region + key + "_channel", syncKeys);
    }

    public static synchronized SyncKeys keys(String region, String key) {
        SyncKeys syncKeys = KEY_INFO.get(region + key);
        if (syncKeys == null) {
            AbstractSyncCache.initKeys(region, key);
        }
        return KEY_INFO.get(region + key);
    }

    static synchronized SyncKeys keysByChannel(String channel) {
        SyncKeys syncKeys = CHANNEL_KEY_INFO.get(channel);
        if (syncKeys == null) {
            throw new CacheSyncException("\u672a\u627e\u5230\u7f13\u5b58\u540c\u6b65\u76f8\u5173key\u4fe1\u606f");
        }
        return syncKeys;
    }

    static void remove(SyncKeys syncKeys) {
        KEY_INFO.remove(syncKeys.getRegion() + syncKeys.getData());
        CHANNEL_KEY_INFO.remove(syncKeys.getRegion() + syncKeys.getChannel());
    }
}

