/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.redis;

import cloud.agileframework.cache.support.redis.AgileRedisCacheManager;
import cloud.agileframework.cache.support.redis.StorageAccessImpl;
import cloud.agileframework.spring.util.BeanUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheManager;

public class RedisRegionFactory
extends RegionFactoryTemplate {
    private final Logger logger = LoggerFactory.getLogger(RedisRegionFactory.class);
    private static final AtomicInteger REFERENCE_COUNT = new AtomicInteger();
    private volatile RedisCacheManager cacheManager;
    private RedisCacheManager redisCacheManager;

    protected DomainDataStorageAccess createDomainDataStorageAccess(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new StorageAccessImpl((RedisCache)this.getOrCreateCache(regionConfig.getRegionName(), buildingContext.getSessionFactory()));
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new StorageAccessImpl((RedisCache)this.getOrCreateCache(regionName, sessionFactory));
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new StorageAccessImpl((RedisCache)this.getOrCreateCache(regionName, sessionFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareForUse(SessionFactoryOptions settings, Map configValues) {
        RedisRegionFactory redisRegionFactory = this;
        synchronized (redisRegionFactory) {
            this.cacheManager = (RedisCacheManager)this.resolveCacheManager();
            if (this.cacheManager == null) {
                String msg = "\u5f00\u542f Redis CacheManager \u5931\u8d25";
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(msg);
                }
                throw new CacheException(msg);
            }
        }
    }

    protected void releaseFromUse() {
        if (REFERENCE_COUNT.decrementAndGet() == 0) {
            this.cacheManager = null;
        }
    }

    private Cache getOrCreateCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        Cache cache = this.cacheManager.getCache(qualifiedRegionName);
        if (cache == null) {
            throw new CacheException("\u672a\u6210\u529f\u83b7\u53d6\u533a\u57df [" + qualifiedRegionName + "]");
        }
        return cache;
    }

    private CacheManager resolveCacheManager() {
        return this.useExplicitCacheManager();
    }

    private CacheManager useExplicitCacheManager() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u5b8c\u6210\u521d\u59cb\u5316Redis\u4e8c\u7ea7\u7f13\u5b58\u533a\u57df");
            }
            this.redisCacheManager = ((AgileRedisCacheManager)BeanUtil.getBean(AgileRedisCacheManager.class)).getCacheManager();
            REFERENCE_COUNT.incrementAndGet();
            return this.redisCacheManager;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error("\u521d\u59cb\u5316Redis\u4e8c\u7ea7\u7f13\u5b58\u533a\u57df\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
            REFERENCE_COUNT.decrementAndGet();
            throw e;
        }
    }
}

