/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.ehcache;

import cloud.agileframework.cache.support.ehcache.AgileEhCacheCacheManager;
import cloud.agileframework.spring.util.BeanUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.ehcache.internal.SingletonEhcacheRegionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheRegionFactory
extends SingletonEhcacheRegionFactory {
    private final Logger logger = LoggerFactory.getLogger(EhCacheRegionFactory.class);
    private static final AtomicInteger REFERENCE_COUNT = new AtomicInteger();
    private volatile CacheManager cacheManager;

    protected CacheManager resolveCacheManager(SessionFactoryOptions settings, Map properties) {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5b8c\u6210\u521d\u59cb\u5316EhCache\u4e8c\u7ea7\u7f13\u5b58\u533a\u57df");
            }
            REFERENCE_COUNT.incrementAndGet();
            return ((AgileEhCacheCacheManager)BeanUtil.getBean(AgileEhCacheCacheManager.class)).getCacheManager();
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("\u521d\u59cb\u5316EhCache\u4e8c\u7ea7\u7f13\u5b58\u533a\u57df\u5931\u8d25", (Throwable)e);
            }
            REFERENCE_COUNT.decrementAndGet();
            throw e;
        }
    }

    protected Cache createCache(String regionName) {
        return (Cache)this.getCacheManager().addCacheIfAbsent(regionName);
    }
}

