/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.ehcache;

import cloud.agileframework.cache.support.AbstractAgileCache;
import cloud.agileframework.cache.sync.OpType;
import cloud.agileframework.cache.sync.SyncCache;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.spring.util.AsyncUtil;
import cloud.agileframework.spring.util.BeanUtil;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.NumberUtils;

public class AgileEhCache
extends AbstractAgileCache {
    public static final CacheException CACHE_EXCEPTION = new CacheException("Target data is not the expected type");
    private static final AntPathMatcher ANT = new AntPathMatcher();

    AgileEhCache(EhCacheCache cache) {
        super((Cache)cache);
    }

    public Ehcache getNativeCache() {
        return (Ehcache)super.getNativeCache();
    }

    private SyncCache syncCache() {
        return (SyncCache)BeanUtil.getBean(SyncCache.class);
    }

    @Override
    public <T> T get(Object key, Class<T> clazz) {
        return (T)this.syncCache().sync(this.getName(), key.toString(), () -> {
            Cache.ValueWrapper v = super.get(key);
            if (v == null) {
                return null;
            }
            Object o = v.get();
            if (o == null) {
                return null;
            }
            if (o.getClass() == clazz) {
                return o;
            }
            return ObjectUtil.to((Object)o, (TypeReference)new TypeReference((Type)clazz));
        }, OpType.READ);
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        return this.syncCache().sync(this.getName(), key.toString(), () -> super.get(key), OpType.READ);
    }

    @Override
    public <T> T get(Object key, Callable<T> valueLoader) {
        return (T)this.syncCache().sync(this.getName(), key.toString(), () -> super.get(key, valueLoader), OpType.READ);
    }

    @Override
    public <T> T get(Object key, TypeReference<T> typeReference) {
        return (T)this.syncCache().sync(this.getName(), key.toString(), () -> super.get(key, typeReference), OpType.READ);
    }

    public boolean evictIfPresent(Object key) {
        return this.syncCache().sync(this.getName(), key.toString(), () -> super.evictIfPresent(key), OpType.WRITE);
    }

    public boolean invalidate() {
        boolean notEmpty = this.getNativeCache().getSize() > 0;
        this.syncCache().clear(this.getName());
        return notEmpty;
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        this.syncCache().sync(this.getName(), key.toString(), () -> {
            Ehcache ehCache = this.getNativeCache();
            Element element = new Element(key, value);
            element.setTimeToLive(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
            element.setTimeToIdle(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
            element.setEternal(false);
            Element old = ehCache.get(key);
            if (old == null) {
                ehCache.put(element);
            } else {
                ehCache.replace(old, element);
            }
            AsyncUtil.execute(() -> this.evict(key), (Duration)timeout);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public void put(Object key, Object value) {
        this.syncCache().sync(this.getName(), key.toString(), () -> {
            this.directPut(key, value);
            return null;
        }, OpType.WRITE);
    }

    public void directPut(Object key, Object value) {
        long randomRange = RandomUtils.nextLong((long)1680000L, (long)1920000L);
        Duration timeout = Duration.ofMillis(randomRange);
        Ehcache ehCache = this.getNativeCache();
        Element element = new Element(key, value);
        element.setTimeToIdle(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setEternal(false);
        Element old = ehCache.get(key);
        if (old == null) {
            ehCache.put(element);
        } else {
            ehCache.replace(old, element);
        }
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        return this.syncCache().sync(this.getName(), key.toString(), () -> super.putIfAbsent(key, value), OpType.WRITE);
    }

    @Override
    public void evict(Object key) {
        this.syncCache().sync(this.getName(), key.toString(), () -> {
            this.directEvict(key);
            return null;
        }, OpType.DELETE);
    }

    public void directEvict(Object key) {
        super.evict(key);
    }

    @Override
    public boolean containKey(Object key) {
        return this.syncCache().sync(this.getName(), key.toString(), () -> this.getNativeCache().get(key) != null, OpType.READ);
    }

    private Map<Object, Object> directGetMap(Object mapKey) {
        Element value = this.getNativeCache().get(mapKey);
        if (value == null) {
            HashMap<Object, Object> result = new HashMap<Object, Object>(0);
            value = new Element(mapKey, result);
            this.getNativeCache().put(value);
            return result;
        }
        Object map = value.getObjectValue();
        if (!Map.class.isAssignableFrom(map.getClass())) {
            throw CACHE_EXCEPTION;
        }
        return (Map)map;
    }

    private List<Object> directGetList(Object listKey) {
        Element value = this.getNativeCache().get(listKey);
        if (value == null) {
            ArrayList<Object> result = new ArrayList<Object>();
            value = new Element(listKey, result);
            this.getNativeCache().put(value);
            return result;
        }
        Object list = value.getObjectValue();
        if (!List.class.isAssignableFrom(list.getClass())) {
            throw CACHE_EXCEPTION;
        }
        return (List)list;
    }

    private Set<Object> directGetSet(Object setKey) {
        Element value = this.getNativeCache().get(setKey);
        if (value == null) {
            HashSet<Object> result = new HashSet<Object>();
            value = new Element(setKey, result);
            this.getNativeCache().put(value);
            return result;
        }
        Object map = value.getObjectValue();
        if (!Set.class.isAssignableFrom(map.getClass())) {
            throw CACHE_EXCEPTION;
        }
        return (Set)map;
    }

    @Override
    public void addToMap(Object mapKey, Object key, Object value) {
        this.syncCache().sync(this.getName(), mapKey.toString(), () -> {
            Map<Object, Object> map = this.directGetMap(mapKey);
            map.put(key, value);
            this.put(mapKey, map);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public Object getFromMap(Object mapKey, Object key) {
        return this.syncCache().sync(this.getName(), mapKey.toString(), () -> {
            Map<Object, Object> map = this.directGetMap(mapKey);
            return map.get(key);
        }, OpType.READ);
    }

    @Override
    public <T> T getFromMap(Object mapKey, Object key, Class<T> clazz) {
        return (T)this.syncCache().sync(this.getName(), mapKey.toString(), () -> {
            Map<Object, Object> map = this.directGetMap(mapKey);
            Object value = map.get(key);
            if (value != null && clazz != null && !clazz.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + clazz.getName() + "]: " + value);
            }
            return value;
        }, OpType.READ);
    }

    @Override
    public void removeFromMap(Object mapKey, Object key) {
        this.syncCache().sync(this.getName(), mapKey.toString(), () -> {
            Map<Object, Object> map = this.directGetMap(mapKey);
            map.remove(key);
            this.put(mapKey, map);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public void addToList(Object listKey, Object node) {
        this.syncCache().sync(this.getName(), listKey.toString(), () -> {
            List<Object> list = this.directGetList(listKey);
            list.add(node);
            this.put(listKey, list);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public Object getFromList(Object listKey, int index) {
        return this.syncCache().sync(this.getName(), listKey.toString(), () -> {
            List<Object> list = this.directGetList(listKey);
            return list.get(index);
        }, OpType.READ);
    }

    @Override
    public <T> T getFromList(Object listKey, int index, Class<T> clazz) {
        return (T)this.syncCache().sync(this.getName(), listKey.toString(), () -> {
            Object value = this.getFromList(listKey, index);
            if (value != null && clazz != null && !clazz.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + clazz.getName() + "]: " + value);
            }
            return value;
        }, OpType.READ);
    }

    @Override
    public void removeFromList(Object listKey, int index) {
        this.syncCache().sync(this.getName(), listKey.toString(), () -> {
            List<Object> list = this.directGetList(listKey);
            list.remove(index);
            this.put(listKey, list);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public void removeFromList0(Object listKey, Object o) {
        this.syncCache().sync(this.getName(), listKey.toString(), () -> {
            List<Object> list = this.directGetList(listKey);
            list.remove(o);
            this.put(listKey, list);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public void addToSet(Object setKey, Object node) {
        this.syncCache().sync(this.getName(), setKey.toString(), () -> {
            Set<Object> set = this.directGetSet(setKey);
            set.add(node);
            this.put(setKey, set);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public void removeFromSet(Object setKey, Object node) {
        this.syncCache().sync(this.getName(), setKey.toString(), () -> {
            Set<Object> set = this.directGetSet(setKey);
            set.remove(node);
            this.put(setKey, set);
            return null;
        }, OpType.WRITE);
    }

    @Override
    public synchronized boolean lock(Object lock) {
        boolean isLock;
        Ehcache ehcache = this.getNativeCache();
        try {
            isLock = ehcache.tryWriteLockOnKey(lock, 1L);
        }
        catch (InterruptedException e) {
            isLock = false;
            Thread.currentThread().interrupt();
        }
        return isLock;
    }

    public synchronized boolean lockRead(Object lock) {
        boolean isLock;
        Ehcache ehcache = this.getNativeCache();
        try {
            isLock = ehcache.tryReadLockOnKey(lock, 1L);
        }
        catch (InterruptedException e) {
            isLock = false;
            Thread.currentThread().interrupt();
        }
        return isLock;
    }

    @Override
    public void unlock(Object lock) {
        Ehcache ehcache = this.getNativeCache();
        ehcache.releaseWriteLockOnKey(lock);
    }

    @Override
    public List<String> keys(Object key) {
        return this.syncCache().sync(this.getName(), key.toString(), () -> {
            String pattern = String.valueOf(key);
            Ehcache ehCache = this.getNativeCache();
            List keys = ehCache.getKeys();
            return keys.stream().map(String::valueOf).filter(b -> ANT.match(pattern, b)).collect(Collectors.toList());
        }, OpType.READ);
    }
}

