/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.config;

import cloud.agileframework.cache.config.CacheAutoConfiguration;
import cloud.agileframework.cache.support.redis.AgileRedisCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConditionalOnProperty(name={"type"}, prefix="spring.cache", havingValue="redis")
@ConditionalOnClass(value={RedisCacheManager.class})
public class RedisAutoConfiguration
implements CacheAutoConfiguration {
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    private RedisCacheManager redisCacheManager;

    @Override
    @Bean
    public AgileRedisCacheManager agileCacheManager() {
        return new AgileRedisCacheManager(this.redisCacheManager, this.redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisCacheManager.class})
    public RedisCacheManager redisCacheManager() {
        return RedisCacheManager.create((RedisConnectionFactory)this.redisConnectionFactory);
    }
}

