/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.config;

import cloud.agileframework.cache.properties.EhCacheProperties;
import cloud.agileframework.cache.support.redis.AgileRedisCacheManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@EnableConfigurationProperties(value={EhCacheProperties.class})
@ConditionalOnClass(value={RedisCacheManager.class})
@ConditionalOnBean(value={RedisCacheManager.class})
@ConditionalOnProperty(name={"type"}, prefix="spring.cache", havingValue="redis")
public class RedisAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={RedisCacheManager.class})
    AgileRedisCacheManager agileRedisCacheManager(RedisCacheManager cacheManager, RedisConnectionFactory redisConnectionFactory) {
        return new AgileRedisCacheManager(cacheManager, redisConnectionFactory);
    }
}

