/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.util;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.support.AgileCacheManagerInterface;
import java.time.Duration;
import org.springframework.cache.Cache;

public class CacheUtil {
    private static AgileCacheManagerInterface agileCacheManager;
    private static final String DEFAULT_CACHE_NAME = "common-cache";

    public static void setAgileCacheManager(AgileCacheManagerInterface agileCacheManager) {
        CacheUtil.agileCacheManager = agileCacheManager;
    }

    public static AgileCacheManagerInterface getAgileCacheManager() {
        return agileCacheManager;
    }

    public static AgileCache getCache() {
        return CacheUtil.getAgileCacheManager().getCache(DEFAULT_CACHE_NAME);
    }

    public static AgileCache getCache(String cacheName) {
        return CacheUtil.getAgileCacheManager().getCache(cacheName);
    }

    @Deprecated
    public static void put(Cache cache, Object key, Object value, int timeout) {
        CacheUtil.getCache(cache.getName()).put(key, value, Duration.ofSeconds(timeout));
    }

    @Deprecated
    public static void put(AgileCache cache, Object key, Object value, int timeout) {
        CacheUtil.getCache(cache.getName()).put(key, value, Duration.ofSeconds(timeout));
    }

    @Deprecated
    public static void put(Object key, Object value, int timeout) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).put(key, value, Duration.ofSeconds(timeout));
    }

    public static String getName() {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).getName();
    }

    public static Object getNativeCache() {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).getNativeCache();
    }

    public static Object get(Object key) {
        Cache.ValueWrapper v = CacheUtil.getCache(DEFAULT_CACHE_NAME).get(key);
        if (v == null) {
            return null;
        }
        return v.get();
    }

    public static void putIfAbsent(String key, Object value) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).putIfAbsent(key, value);
    }

    public static void put(Object key, Object value, Duration timeout) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).put(key, value, timeout);
    }

    public static void put(Object key, Object value) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).put(key, value);
    }

    public static <T> T get(Object key, Class<T> clazz) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).get(key, clazz);
    }

    public static void evict(Object key) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).evict(key);
    }

    public static void clear() {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).clear();
    }

    public static boolean containKey(Object key) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).containKey(key);
    }

    public static void addToMap(Object mapKey, Object key, Object value) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).addToMap(mapKey, key, value);
    }

    public static Object getFromMap(Object mapKey, Object key) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).getFromMap(mapKey, key);
    }

    public static <T> T getFromMap(Object mapKey, Object key, Class<T> tClass) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).getFromMap(mapKey, key, tClass);
    }

    public static void removeFromMap(Object mapKey, Object key) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).removeFromMap(mapKey, key);
    }

    public static void addToList(Object listKey, Object node) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).addToList(listKey, node);
    }

    public static Object getFromList(Object listKey, int index) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).getFromList(listKey, index);
    }

    public static <T> T getFromList(Object listKey, int index, Class<T> tClass) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).getFromList(listKey, index, tClass);
    }

    public static void removeFromList(Object listKey, int index) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).removeFromList(listKey, index);
    }

    public static void addToSet(Object setKey, Object node) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).addToSet(setKey, node);
    }

    public static void removeFromSet(Object setKey, Object node) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).removeFromSet(setKey, node);
    }

    public static boolean lock(Object lock) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).lock(lock);
    }

    public static boolean lock(Object lock, Duration timeout) {
        return CacheUtil.getCache(DEFAULT_CACHE_NAME).lock(lock, timeout);
    }

    public static void unlock(Object lock) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).unlock(lock);
    }

    public static void unlock(Object lock, Duration timeout) {
        CacheUtil.getCache(DEFAULT_CACHE_NAME).unlock(lock, timeout);
    }
}

