/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import chat.dim.type.IntegerData;

public class UInt16Data
extends Data
implements IntegerData {
    public final int value;
    public final IntegerData.Endian endian;
    public static final UInt16Data ZERO = UInt16Data.from(0, IntegerData.Endian.BIG_ENDIAN);

    public UInt16Data(ByteArray data, int value, IntegerData.Endian endian) {
        super(data);
        this.value = value;
        this.endian = endian;
        assert (data.getSize() == 2) : "UInt16Data error: size=" + data.getSize();
    }

    public UInt16Data(byte[] bytes, int offset, int value, IntegerData.Endian endian) {
        super(bytes, offset, 2);
        this.value = value;
        this.endian = endian;
        assert (bytes.length >= offset + 2) : "UInt16Data error: offset=" + offset + ", length=" + bytes.length;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IntegerData) {
            return this.value == ((IntegerData)other).getIntValue();
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public static UInt16Data from(UInt16Data data) {
        return data;
    }

    public static UInt16Data from(ByteArray data, IntegerData.Endian endian) {
        if (data.getSize() < 2) {
            return null;
        }
        if (data.getSize() > 2) {
            data = data.slice(0, 2);
        }
        int value = UInt16Data.getValue(data, endian);
        return new UInt16Data(data, value, endian);
    }

    public static UInt16Data from(byte[] bytes, IntegerData.Endian endian) {
        if (bytes.length < 2) {
            return null;
        }
        int value = UInt16Data.getValue(bytes, 0, endian);
        return new UInt16Data(bytes, 0, value, endian);
    }

    public static UInt16Data from(byte[] bytes, int offset, IntegerData.Endian endian) {
        if (bytes.length < offset + 2) {
            return null;
        }
        int value = UInt16Data.getValue(bytes, offset, endian);
        return new UInt16Data(bytes, offset, value, endian);
    }

    public static UInt16Data from(int value, IntegerData.Endian endian) {
        ByteArray data = UInt16Data.getData(value, endian);
        return new UInt16Data(data, value, endian);
    }

    private static int getValue(ByteArray data, IntegerData.Endian endian) {
        assert (data.getSize() == 2) : "UInt16Data error: size=" + data.getSize();
        return (int)IntegerData.getValue(data, endian);
    }

    private static int getValue(byte[] bytes, int offset, IntegerData.Endian endian) {
        assert (bytes.length == offset + 2) : "UInt16Data error: offset=" + offset + ", length=" + bytes.length;
        return (int)IntegerData.getValue(bytes, offset, 2, endian);
    }

    private static ByteArray getData(int value, IntegerData.Endian endian) {
        byte[] buffer = new byte[2];
        IntegerData.setValue((long)value, buffer, 0, 2, endian);
        return new Data(buffer);
    }
}

