/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import chat.dim.type.MutableByteArray;

public class MutableData
extends Data
implements MutableByteArray {
    public MutableData(ByteArray data) {
        super(data);
    }

    public MutableData(byte[] bytes) {
        super(bytes);
    }

    public MutableData(byte[] bytes, int offset, int size) {
        super(bytes, offset, size);
    }

    public MutableData(int capacity) {
        this(new byte[capacity], 0, 0);
    }

    public MutableData() {
        this(4);
    }

    void resize(int newSize) {
        assert (newSize > this.size) : "size too small for old data: new size=" + newSize + ", view size=" + this.size;
        byte[] bytes = new byte[newSize];
        System.arraycopy(this.buffer, this.offset, bytes, 0, this.size);
        this.buffer = bytes;
        this.offset = 0;
    }

    void expands() {
        int capacity = this.buffer.length - this.offset;
        if (capacity > 2) {
            this.resize(capacity << 1);
        } else {
            this.resize(4);
        }
    }

    @Override
    public void setChar(int index, char value) {
        this.setByte(index, (byte)value);
    }

    @Override
    public void setByte(int index, byte value) {
        if ((index = ByteArray.adjustE(index, this.size)) >= this.size) {
            if (index >= this.buffer.length) {
                this.resize(index + 1);
            } else if (this.offset + index >= this.buffer.length) {
                System.arraycopy(this.buffer, this.offset, this.buffer, 0, this.size);
                this.offset = 0;
            }
            this.size = index + 1;
        }
        this.buffer[this.offset + index] = value;
    }

    @Override
    public void update(int index, byte[] source, int start, int end) {
        if ((start = ByteArray.adjust(start, source.length)) < (end = ByteArray.adjust(end, source.length))) {
            index = ByteArray.adjustE(index, this.size);
            MutableByteArray.update(this, index, source, start, end);
        }
    }

    @Override
    public void update(int index, byte[] source, int start) {
        this.update(index, source, start, source.length);
    }

    @Override
    public void update(int index, byte[] source) {
        this.update(index, source, 0, source.length);
    }

    @Override
    public void update(int index, ByteArray source, int start, int end) {
        int srcLen = source.getSize();
        if ((start = ByteArray.adjust(start, srcLen)) < (end = ByteArray.adjust(end, srcLen))) {
            index = ByteArray.adjustE(index, this.size);
            byte[] srcBuf = source.getBuffer();
            int srcOffset = source.getOffset();
            MutableByteArray.update(this, index, srcBuf, srcOffset + start, srcOffset + end);
        }
    }

    @Override
    public void update(int index, ByteArray source, int start) {
        this.update(index, source, start, source.getSize());
    }

    @Override
    public void update(int index, ByteArray source) {
        this.update(index, source, 0, source.getSize());
    }

    @Override
    public void append(byte[] source, int start, int end) {
        if ((start = ByteArray.adjust(start, source.length)) < (end = ByteArray.adjust(end, source.length))) {
            MutableByteArray.update(this, this.size, source, start, end);
        }
    }

    @Override
    public void append(byte[] source, int start) {
        this.append(source, start, source.length);
    }

    @Override
    public void append(byte[] source) {
        this.append(source, 0, source.length);
    }

    @Override
    public void append(byte[] ... sources) {
        for (byte[] src : sources) {
            this.append(src, 0, src.length);
        }
    }

    @Override
    public void append(ByteArray source, int start, int end) {
        int srcLen = source.getSize();
        if ((start = ByteArray.adjust(start, srcLen)) < (end = ByteArray.adjust(end, srcLen))) {
            byte[] srcBuf = source.getBuffer();
            int srcOffset = source.getOffset();
            MutableByteArray.update(this, this.size, srcBuf, srcOffset + start, srcOffset + end);
        }
    }

    @Override
    public void append(ByteArray source, int start) {
        this.append(source, start, source.getSize());
    }

    @Override
    public void append(ByteArray source) {
        this.append(source, 0, source.getSize());
    }

    @Override
    public void append(ByteArray ... sources) {
        for (ByteArray src : sources) {
            this.append(src, 0, src.getSize());
        }
    }

    @Override
    public void insert(int index, byte[] source, int start, int end) {
        if ((start = ByteArray.adjustE(start, source.length)) < (end = ByteArray.adjustE(end, source.length))) {
            index = ByteArray.adjustE(index, this.size);
            MutableByteArray.insert(this, index, source, start, end);
        }
    }

    @Override
    public void insert(int index, byte[] source, int start) {
        this.insert(index, source, start, source.length);
    }

    @Override
    public void insert(int index, byte[] source) {
        this.insert(index, source, 0, source.length);
    }

    @Override
    public void insert(int index, ByteArray source, int start, int end) {
        int srcLen = source.getSize();
        if ((start = ByteArray.adjustE(start, srcLen)) < (end = ByteArray.adjustE(end, srcLen))) {
            index = ByteArray.adjustE(index, this.size);
            byte[] srcBuf = source.getBuffer();
            int srcOffset = source.getOffset();
            MutableByteArray.insert(this, index, srcBuf, srcOffset + start, srcOffset + end);
        }
    }

    @Override
    public void insert(int index, ByteArray source, int start) {
        this.insert(index, source, start, source.getSize());
    }

    @Override
    public void insert(int index, ByteArray source) {
        this.insert(index, source, 0, source.getSize());
    }

    @Override
    public void insert(int index, byte value) {
        if ((index = ByteArray.adjustE(index, this.size)) < this.size) {
            MutableByteArray.insert(this, index, value);
        } else {
            this.setByte(index, value);
        }
    }

    @Override
    public byte remove(int index) {
        if ((index = ByteArray.adjustE(index, this.size)) >= this.size) {
            throw new ArrayIndexOutOfBoundsException("index error: " + index + ", size: " + this.size);
        }
        if (index == 0) {
            return this.shift();
        }
        if (index == this.size - 1) {
            return this.pop();
        }
        return MutableByteArray.remove(this, index);
    }

    @Override
    public byte shift() {
        if (this.size < 1) {
            throw new ArrayIndexOutOfBoundsException("data empty!");
        }
        byte erased = this.buffer[this.offset];
        ++this.offset;
        --this.size;
        return erased;
    }

    @Override
    public byte pop() {
        if (this.size < 1) {
            throw new ArrayIndexOutOfBoundsException("data empty!");
        }
        --this.size;
        return this.buffer[this.offset + this.size];
    }

    @Override
    public void push(byte element) {
        this.setByte(this.size, element);
    }

    @Override
    public void append(byte element) {
        this.setByte(this.size, element);
    }

    @Override
    public void append(char element) {
        this.setChar(this.size, element);
    }
}

