/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.MutableData;

public interface MutableByteArray
extends ByteArray {
    public static final Helper helper = new Helper(){

        @Override
        public void update(MutableData data, int index, byte[] source, int start, int end) {
            assert (index >= 0) : "update index error: " + index;
            assert (start >= 0 & end <= source.length) : "source range error: [" + start + ", " + end + "), size: " + source.length;
            int copyLen = end - start;
            assert (copyLen > 0) : "source range error: [" + start + ", " + end + ")";
            int copyEnd = index + copyLen;
            if (source != data.buffer || data.offset + index != start) {
                if (data.offset + copyEnd > data.buffer.length) {
                    if (source == data.buffer || copyEnd > data.buffer.length) {
                        data.resize(copyEnd);
                    } else {
                        System.arraycopy(data.buffer, data.offset, data.buffer, 0, data.size);
                        data.offset = 0;
                    }
                }
                System.arraycopy(source, start, data.buffer, data.offset + index, copyLen);
            }
            if (copyEnd > data.size) {
                data.size = copyEnd;
            }
        }

        @Override
        public void insert(MutableData data, int index, byte[] source, int start, int end) {
            assert (index >= 0) : "insert index error: " + index;
            assert (start >= 0 & end <= source.length) : "source range error: [" + start + ", " + end + "), size: " + source.length;
            int copyLen = end - start;
            assert (copyLen > 0) : "source range error: [" + start + ", " + end + ")";
            int newLen = index < data.size ? data.size + copyLen : index + copyLen;
            if (data.buffer == source || newLen > data.buffer.length) {
                data.resize(newLen);
            } else if (index < data.size >> 1) {
                if (data.offset >= copyLen) {
                    if (index > 0) {
                        System.arraycopy(data.buffer, data.offset, data.buffer, data.offset - copyLen, index);
                    }
                    data.offset -= copyLen;
                } else if (data.offset + newLen < data.buffer.length) {
                    if (index < data.size) {
                        System.arraycopy(data.buffer, data.offset + index, data.buffer, data.offset + index + copyLen, data.size - index);
                    }
                } else {
                    System.arraycopy(data.buffer, data.offset, data.buffer, 0, index);
                    System.arraycopy(data.buffer, data.offset + index, data.buffer, index + copyLen, data.size - index);
                    data.offset = 0;
                }
            } else if (data.offset + newLen < data.buffer.length) {
                if (index < data.size) {
                    System.arraycopy(data.buffer, data.offset + index, data.buffer, data.offset + index + copyLen, data.size - index);
                }
            } else if (data.offset >= newLen - data.size) {
                System.arraycopy(data.buffer, data.offset, data.buffer, data.offset - copyLen, Math.min(index, data.size));
                data.offset -= copyLen;
            } else if (index < data.size) {
                System.arraycopy(data.buffer, data.offset, data.buffer, 0, index);
                System.arraycopy(data.buffer, data.offset + index, data.buffer, index + copyLen, data.size - index);
                data.offset = 0;
            } else {
                System.arraycopy(data.buffer, data.offset, data.buffer, 0, data.size);
                data.offset = 0;
            }
            System.arraycopy(source, start, data.buffer, data.offset + index, copyLen);
            data.size = newLen;
        }

        @Override
        public void insert(MutableData data, int index, byte value) {
            assert (0 <= index && index < data.size) : "index out of range: " + index + ", " + data.size;
            if (index == 0) {
                if (data.offset > 0) {
                    --data.offset;
                } else {
                    if (data.size >= data.buffer.length) {
                        data.expands();
                    }
                    System.arraycopy(data.buffer, 0, data.buffer, 1, data.size);
                }
            } else if (index < data.size >> 1) {
                if (data.offset > 0) {
                    System.arraycopy(data.buffer, data.offset, data.buffer, data.offset - 1, index);
                    --data.offset;
                } else {
                    if (data.size >= data.buffer.length) {
                        data.expands();
                    }
                    System.arraycopy(data.buffer, data.offset + index, data.buffer, data.offset + index + 1, data.size - index);
                }
            } else if (data.offset + data.size < data.buffer.length) {
                System.arraycopy(data.buffer, data.offset + index, data.buffer, data.offset + index + 1, data.size - index);
            } else if (data.offset > 0) {
                System.arraycopy(data.buffer, data.offset, data.buffer, data.offset - 1, index);
                --data.offset;
            } else {
                data.expands();
                System.arraycopy(data.buffer, data.offset + index, data.buffer, data.offset + index + 1, data.size - index);
            }
            data.buffer[data.offset + index] = value;
            ++data.size;
        }

        @Override
        public byte remove(MutableData data, int index) {
            assert (0 < index && index < data.size - 1) : "index out of range: " + index + ", " + data.size;
            byte erased = data.buffer[data.offset + index];
            if (index < data.size >> 1) {
                System.arraycopy(data.buffer, data.offset, data.buffer, data.offset + 1, index);
                ++data.offset;
            } else {
                System.arraycopy(data.buffer, data.offset + index + 1, data.buffer, data.offset + index, data.size - index - 1);
            }
            --data.size;
            return erased;
        }
    };

    public void setByte(int var1, byte var2);

    public void setChar(int var1, char var2);

    public void update(int var1, byte[] var2, int var3, int var4);

    public void update(int var1, byte[] var2, int var3);

    public void update(int var1, byte[] var2);

    public void update(int var1, ByteArray var2, int var3, int var4);

    public void update(int var1, ByteArray var2, int var3);

    public void update(int var1, ByteArray var2);

    public void append(byte[] var1, int var2, int var3);

    public void append(byte[] var1, int var2);

    public void append(byte[] var1);

    public void append(byte[] ... var1);

    public void append(ByteArray var1, int var2, int var3);

    public void append(ByteArray var1, int var2);

    public void append(ByteArray var1);

    public void append(ByteArray ... var1);

    public void insert(int var1, byte[] var2, int var3, int var4);

    public void insert(int var1, byte[] var2, int var3);

    public void insert(int var1, byte[] var2);

    public void insert(int var1, ByteArray var2, int var3, int var4);

    public void insert(int var1, ByteArray var2, int var3);

    public void insert(int var1, ByteArray var2);

    public void insert(int var1, byte var2);

    public byte remove(int var1);

    public byte shift();

    public byte pop();

    public void append(char var1);

    public void append(byte var1);

    public void push(byte var1);

    public static void update(MutableData data, int index, byte[] source, int start, int end) {
        helper.update(data, index, source, start, end);
    }

    public static void insert(MutableData data, int index, byte[] source, int start, int end) {
        helper.insert(data, index, source, start, end);
    }

    public static void insert(MutableData data, int index, byte value) {
        helper.insert(data, index, value);
    }

    public static byte remove(MutableData data, int index) {
        return helper.remove(data, index);
    }

    public static interface Helper {
        public void update(MutableData var1, int var2, byte[] var3, int var4, int var5);

        public void insert(MutableData var1, int var2, byte[] var3, int var4, int var5);

        public void insert(MutableData var1, int var2, byte var3);

        public byte remove(MutableData var1, int var2);
    }
}

