/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.MutableData;
import java.util.Random;

public class Data
implements ByteArray,
Cloneable {
    byte[] buffer;
    int offset;
    int size;
    public static final Data ZERO = new Data(new byte[0]);

    public Data(byte[] buffer, int offset, int size) {
        this.buffer = buffer;
        this.offset = offset;
        this.size = size;
        assert (buffer.length >= offset + size) : "range error: " + buffer.length + " < " + offset + " + " + size;
    }

    public Data(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public Data(ByteArray data) {
        this(data.getBuffer(), data.getOffset(), data.getSize());
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteArray) {
            return this.equals((ByteArray)other);
        }
        if (other instanceof byte[]) {
            return this.equals((byte[])other);
        }
        return false;
    }

    @Override
    public boolean equals(ByteArray other) {
        return this == other || this.equals(other.getBuffer(), other.getOffset(), other.getSize());
    }

    @Override
    public boolean equals(byte[] other) {
        return this.equals(other, 0, other.length);
    }

    @Override
    public boolean equals(byte[] otherBuffer, int otherOffset, int otherCount) {
        if (otherCount != this.size) {
            return false;
        }
        if (otherBuffer == this.buffer && otherOffset == this.offset) {
            return true;
        }
        int pos1 = this.offset + this.size - 1;
        int pos2 = otherOffset + otherCount - 1;
        while (pos1 >= this.offset) {
            if (this.buffer[pos1] != otherBuffer[pos2]) {
                return false;
            }
            --pos1;
            --pos2;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        int end = this.offset + this.size;
        for (int start = this.offset; start < end; ++start) {
            result = (result << 5) - result + this.buffer[start];
        }
        return result;
    }

    public String toString() {
        return new String(this.getBytes());
    }

    @Override
    public String toHexString() {
        return ByteArray.hexEncode(this.buffer, this.offset, this.size);
    }

    @Override
    public int find(byte value, int start, int end) {
        return ByteArray.find(this, value, ByteArray.adjust(start, this.size), ByteArray.adjust(end, this.size));
    }

    @Override
    public int find(byte value, int start) {
        return ByteArray.find(this, value, ByteArray.adjust(start, this.size), this.size);
    }

    @Override
    public int find(byte value) {
        return ByteArray.find(this, value, 0, this.size);
    }

    @Override
    public int find(int value, int start, int end) {
        return ByteArray.find(this, (byte)(value & 0xFF), ByteArray.adjust(start, this.size), ByteArray.adjust(end, this.size));
    }

    @Override
    public int find(int value, int start) {
        return ByteArray.find(this, (byte)(value & 0xFF), ByteArray.adjust(start, this.size), this.size);
    }

    @Override
    public int find(int value) {
        return ByteArray.find(this, (byte)(value & 0xFF), 0, this.size);
    }

    @Override
    public int find(byte[] bytes, int start, int end) {
        return ByteArray.find(this, bytes, 0, bytes.length, ByteArray.adjust(start, this.size), ByteArray.adjust(end, this.size));
    }

    @Override
    public int find(byte[] bytes, int start) {
        return ByteArray.find(this, bytes, 0, bytes.length, ByteArray.adjust(start, this.size), this.size);
    }

    @Override
    public int find(byte[] bytes) {
        return ByteArray.find(this, bytes, 0, bytes.length, 0, this.size);
    }

    @Override
    public int find(ByteArray sub, int start, int end) {
        return ByteArray.find(this, sub.getBuffer(), sub.getOffset(), sub.getSize(), ByteArray.adjust(start, this.size), ByteArray.adjust(end, this.size));
    }

    @Override
    public int find(ByteArray sub, int start) {
        return ByteArray.find(this, sub.getBuffer(), sub.getOffset(), sub.getSize(), ByteArray.adjust(start, this.size), this.size);
    }

    @Override
    public int find(ByteArray sub) {
        return ByteArray.find(this, sub.getBuffer(), sub.getOffset(), sub.getSize(), 0, this.size);
    }

    @Override
    public byte getByte(int index) {
        if ((index = ByteArray.adjustE(index, this.size)) >= this.size) {
            throw new ArrayIndexOutOfBoundsException("error index: " + index + ", size: " + this.size);
        }
        return this.buffer[this.offset + index];
    }

    @Override
    public byte[] getBytes() {
        return ByteArray.slice(this.buffer, this.offset, this.offset + this.size);
    }

    @Override
    public byte[] getBytes(int start) {
        return ByteArray.slice(this.buffer, this.offset + ByteArray.adjust(start, this.size), this.offset + this.size);
    }

    @Override
    public byte[] getBytes(int start, int end) {
        return ByteArray.slice(this.buffer, this.offset + ByteArray.adjust(start, this.size), this.offset + ByteArray.adjust(end, this.size));
    }

    @Override
    public ByteArray slice(int start, int end) {
        return ByteArray.slice(this, ByteArray.adjust(start, this.size), ByteArray.adjust(end, this.size));
    }

    @Override
    public ByteArray slice(int start) {
        return ByteArray.slice(this, ByteArray.adjust(start, this.size), this.size);
    }

    @Override
    public ByteArray concat(ByteArray ... others) {
        ByteArray result = this;
        for (ByteArray item : others) {
            if (item == null) continue;
            result = ByteArray.concat(result, item);
        }
        return result;
    }

    @Override
    public ByteArray concat(byte[] ... others) {
        ByteArray result = this;
        for (byte[] item : others) {
            if (item == null) continue;
            result = ByteArray.concat(result, new Data(item));
        }
        return result;
    }

    public Data clone() throws CloneNotSupportedException {
        Data copy = (Data)super.clone();
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.buffer, this.offset, bytes, 0, this.size);
        copy.buffer = bytes;
        copy.offset = 0;
        copy.size = this.size;
        return copy;
    }

    public MutableData mutableCopy() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.buffer, this.offset, bytes, 0, this.size);
        return new MutableData(bytes);
    }

    public static ByteArray random(int length) {
        byte[] bytes = new byte[length];
        Random random = new Random();
        random.nextBytes(bytes);
        return new Data(bytes);
    }
}

