/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.Data;

public interface ByteArray {
    public static final Helper helper = new Helper(){
        private final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        @Override
        public String hexEncode(byte[] buffer, int offset, int size) {
            if (size < 1) {
                return "";
            }
            StringBuilder sb = new StringBuilder(size << 1);
            int end = offset + size;
            for (int pos = offset; pos < end; ++pos) {
                byte ch = buffer[pos];
                sb.append(this.HEX_CHARS[(ch & 0xF0) >> 4]);
                sb.append(this.HEX_CHARS[ch & 0xF]);
            }
            return sb.toString();
        }

        @Override
        public int adjust(int pos, int len) {
            if (pos < 0) {
                if ((pos += len) < 0) {
                    return 0;
                }
            } else if (pos > len) {
                return len;
            }
            return pos;
        }

        @Override
        public int adjustE(int pos, int len) {
            if (pos < 0 && (pos += len) < 0) {
                throw new ArrayIndexOutOfBoundsException("error position: " + (pos - len) + ", length: " + len);
            }
            return pos;
        }

        @Override
        public ByteArray slice(ByteArray data, int start, int end) {
            if (start == 0 && end == data.getSize()) {
                return data;
            }
            if (start < end) {
                return new Data(data.getBuffer(), data.getOffset() + start, end - start);
            }
            return Data.ZERO;
        }

        @Override
        public byte[] slice(byte[] bytes, int start, int end) {
            if (start == 0 && end == bytes.length) {
                return bytes;
            }
            if (start < end) {
                byte[] sub = new byte[end - start];
                System.arraycopy(bytes, start, sub, 0, end - start);
                return sub;
            }
            return new byte[0];
        }

        @Override
        public ByteArray concat(ByteArray left, ByteArray right) {
            if (right.getSize() == 0) {
                return left;
            }
            if (left.getSize() == 0) {
                return right;
            }
            if (left.getBuffer() == right.getBuffer() && left.getOffset() + left.getSize() == right.getOffset()) {
                return new Data(left.getBuffer(), left.getOffset(), left.getSize() + right.getSize());
            }
            return new Data(this.concat(left.getBuffer(), left.getOffset(), left.getSize(), right.getBuffer(), right.getOffset(), right.getSize()));
        }

        @Override
        public byte[] concat(byte[] leftBuffer, int leftOffset, int leftSize, byte[] rightBuffer, int rightOffset, int rightSize) {
            byte[] joined = new byte[leftSize + rightSize];
            System.arraycopy(leftBuffer, leftOffset, joined, 0, leftSize);
            System.arraycopy(rightBuffer, rightOffset, joined, leftSize, rightSize);
            return joined;
        }

        @Override
        public int find(ByteArray data, byte value, int start, int end) {
            byte[] buffer = data.getBuffer();
            start += data.getOffset();
            end += data.getOffset();
            while (start < end) {
                if (buffer[start] == value) {
                    return start - data.getOffset();
                }
                ++start;
            }
            return -1;
        }

        @Override
        public int find(ByteArray data, byte[] subBuffer, int subOffset, int subSize, int start, int end) {
            assert (subOffset >= 0) : "sub view offset error: " + subOffset;
            assert (subSize >= 0) : "sub view size error: " + subSize;
            assert (start < end) : "search range error: [" + start + ", " + end + ")";
            if (end - start < subSize || subSize <= 0) {
                return -1;
            }
            byte[] buffer = data.getBuffer();
            start += data.getOffset();
            end += data.getOffset();
            int found = -1;
            if (buffer == subBuffer) {
                if (start == subOffset) {
                    return start - data.getOffset();
                }
                if (start < subOffset && subOffset <= end - subSize) {
                    found = subOffset - data.getOffset();
                    end = subOffset + subSize - 1;
                }
            }
            end -= subSize - 1;
            while (start < end) {
                int index;
                for (index = 0; index < subSize && buffer[start + index] == subBuffer[subOffset + index]; ++index) {
                }
                if (index == subSize) {
                    return start - data.getOffset();
                }
                ++start;
            }
            return found;
        }
    };

    public byte[] getBuffer();

    public int getOffset();

    public int getSize();

    public String toHexString();

    public boolean equals(ByteArray var1);

    public boolean equals(byte[] var1);

    public boolean equals(byte[] var1, int var2, int var3);

    public byte getByte(int var1);

    public byte[] getBytes();

    public byte[] getBytes(int var1);

    public byte[] getBytes(int var1, int var2);

    public ByteArray slice(int var1);

    public ByteArray slice(int var1, int var2);

    public ByteArray concat(byte[] ... var1);

    public ByteArray concat(ByteArray ... var1);

    public int find(byte var1, int var2, int var3);

    public int find(byte var1, int var2);

    public int find(byte var1);

    public int find(int var1, int var2, int var3);

    public int find(int var1, int var2);

    public int find(int var1);

    public int find(byte[] var1, int var2, int var3);

    public int find(byte[] var1, int var2);

    public int find(byte[] var1);

    public int find(ByteArray var1, int var2, int var3);

    public int find(ByteArray var1, int var2);

    public int find(ByteArray var1);

    public static String hexEncode(byte[] buffer, int offset, int size) {
        return helper.hexEncode(buffer, offset, size);
    }

    public static int adjust(int pos, int len) {
        return helper.adjust(pos, len);
    }

    public static int adjustE(int pos, int len) {
        return helper.adjustE(pos, len);
    }

    public static ByteArray slice(ByteArray data, int start, int end) {
        return helper.slice(data, start, end);
    }

    public static byte[] slice(byte[] bytes, int start, int end) {
        return helper.slice(bytes, start, end);
    }

    public static ByteArray concat(ByteArray left, ByteArray right) {
        return helper.concat(left, right);
    }

    public static byte[] concat(byte[] leftBuffer, int leftOffset, int leftSize, byte[] rightBuffer, int rightOffset, int rightSize) {
        return helper.concat(leftBuffer, leftOffset, leftSize, rightBuffer, rightOffset, rightSize);
    }

    public static int find(ByteArray data, byte value, int start, int end) {
        return helper.find(data, value, start, end);
    }

    public static int find(ByteArray data, byte[] subBuffer, int subOffset, int subSize, int start, int end) {
        return helper.find(data, subBuffer, subOffset, subSize, start, end);
    }

    public static interface Helper {
        public String hexEncode(byte[] var1, int var2, int var3);

        public int adjust(int var1, int var2);

        public int adjustE(int var1, int var2);

        public ByteArray slice(ByteArray var1, int var2, int var3);

        public byte[] slice(byte[] var1, int var2, int var3);

        public ByteArray concat(ByteArray var1, ByteArray var2);

        public byte[] concat(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

        public int find(ByteArray var1, byte var2, int var3, int var4);

        public int find(ByteArray var1, byte[] var2, int var3, int var4, int var5, int var6);
    }
}

