/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator;

import ch.rasc.extclassgenerator.JsonViews;
import ch.rasc.extclassgenerator.ModelType;
import ch.rasc.extclassgenerator.OutputConfig;
import ch.rasc.extclassgenerator.OutputFormat;
import ch.rasc.extclassgenerator.validation.AbstractValidation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.List;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "type", "defaultValue", "dateFormat", "allowNull", "useNull", "persist", "mapping", "convert", "depends", "calculate"})
public class ModelFieldBean {
    private String name;
    @JsonIgnore
    private ModelType modelType;
    private String type;
    @JsonRawValue
    private Object defaultValue;
    private String dateFormat;
    @JsonView(value={JsonViews.ExtJS4.class})
    private Boolean useNull;
    @JsonView(value={JsonViews.ExtJS5.class, JsonViews.Touch2.class})
    private Boolean allowNull;
    private String mapping;
    private Boolean persist = null;
    @JsonView(value={JsonViews.ExtJS5.class})
    private Boolean critical = null;
    @JsonRawValue
    private String convert;
    @JsonRawValue
    @JsonView(value={JsonViews.ExtJS5.class})
    private String calculate;
    @JsonView(value={JsonViews.ExtJS5.class})
    private List<AbstractValidation> validators;
    @JsonView(value={JsonViews.ExtJS5.class})
    private List<String> depends;
    @JsonView(value={JsonViews.ExtJS5.class})
    private Object reference;
    @JsonView(value={JsonViews.ExtJS5.class})
    private Boolean allowBlank;
    @JsonView(value={JsonViews.ExtJS5.class})
    private Boolean unique;

    public boolean hasOnlyName(OutputConfig outputConfig) {
        if (!(!StringUtils.hasText((String)this.name) || StringUtils.hasText((String)this.type) || this.defaultValue != null || StringUtils.hasText((String)this.dateFormat) || StringUtils.hasText((String)this.mapping) || this.persist != null || StringUtils.hasText((String)this.convert))) {
            if (outputConfig.getOutputFormat() == OutputFormat.EXTJS4) {
                return this.useNull == null;
            }
            if (outputConfig.getOutputFormat() == OutputFormat.TOUCH2) {
                return this.allowNull == null;
            }
            if (outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
                return !(this.allowNull != null || this.critical != null || StringUtils.hasText((String)this.calculate) || this.validators != null && !this.validators.isEmpty() || this.depends != null && !this.depends.isEmpty() || this.reference != null || this.allowBlank != null || this.unique != null);
            }
        }
        return false;
    }

    public ModelFieldBean(String name, ModelType type) {
        this.name = name;
        if (type != null && type != ModelType.NOT_SPECIFIED) {
            this.setModelType(type);
        } else {
            this.setModelType(ModelType.AUTO);
        }
    }

    public ModelFieldBean(String name, String type) {
        this.name = name;
        this.modelType = null;
        this.type = !"auto".equals(type) ? type : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public String getType() {
        return this.type;
    }

    public void setModelType(ModelType type) {
        this.modelType = type;
        this.type = type != ModelType.AUTO ? type.getJsName() : null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Boolean getUseNull() {
        return this.useNull;
    }

    public void setUseNull(Boolean useNull) {
        this.useNull = useNull;
        this.allowNull = useNull;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public Boolean getPersist() {
        return this.persist;
    }

    public void setPersist(Boolean persist) {
        this.persist = persist;
    }

    public Boolean getCritical() {
        return this.critical;
    }

    public void setCritical(Boolean critical) {
        this.critical = critical;
    }

    public String getConvert() {
        return this.convert;
    }

    public void setConvert(String convert) {
        this.convert = convert;
    }

    public String getCalculate() {
        return this.calculate;
    }

    public void setCalculate(String calculate) {
        this.calculate = calculate;
    }

    public List<AbstractValidation> getValidators() {
        return this.validators;
    }

    public void setValidators(List<AbstractValidation> validators) {
        this.validators = validators;
    }

    public List<String> getDepends() {
        return this.depends;
    }

    public void setDepends(List<String> depends) {
        this.depends = depends;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    public Boolean getAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(Boolean allowNull) {
        this.allowNull = allowNull;
        this.useNull = allowNull;
    }

    public Boolean getAllowBlank() {
        return this.allowBlank;
    }

    public void setAllowBlank(Boolean allowBlank) {
        this.allowBlank = allowBlank;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    void updateTypes(OutputConfig outputConfig) {
        if (outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
            if ("int".equals(this.type)) {
                this.type = "integer";
            } else if ("float".equals(this.type)) {
                this.type = "number";
            }
        }
    }
}

