/*
 * @(#)package-info.java
 * Copyright © 2022 Werner Randelshofer, Switzerland. MIT License.
 */

/**
 * Provides fast parsers for Java {@code FloatingPointLiteral}s,
 * and JSON {@code number}s.
 * <p>
 * References:
 * <dl>
 *     <dt>The Java® Language Specification, Java SE 18 Edition,
 *     Chapter 3. Lexical Structure, 3.10.2. Floating-Point Literals</dt>
 *     <dd><a href="https://docs.oracle.com/javase/specs/jls/se18/html/jls-3.html#jls-3.10.2">docs.oracle.com</a></dd>
 *
 *     <dt>IETF RFC 8259. The JavaScript Object Notation (JSON) Data Interchange
 *     Format, Chapter 6. Numbers</dt>
 *     <dd><a href="https://www.ietf.org/rfc/rfc8259.txt">www.ietf.org</a></dd>
 * </dl>
 */
package ch.randelshofer.fastdoubleparser;