/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.filesystem;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;

public class AbstractCollection<T> {
    protected ObjectId getId(T entity) {
        if (entity instanceof AbstractIdentifiableObject) {
            return ((AbstractIdentifiableObject)entity).getId();
        }
        try {
            Object idStr = PropertyUtils.getProperty(entity, (String)"id");
            return idStr != null ? new ObjectId(idStr.toString()) : null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setId(T entity, ObjectId id) {
        if (entity instanceof AbstractIdentifiableObject) {
            ((AbstractIdentifiableObject)entity).setId(id);
        } else {
            try {
                PropertyUtils.setProperty(entity, (String)"id", (Object)id.toString());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

