/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.delegating;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.collections.Collection;
import step.core.collections.CollectionFactory;

public class DelegatingCollectionFactory
implements CollectionFactory {
    private final Logger logger = LoggerFactory.getLogger(DelegatingCollectionFactory.class);
    private final Map<String, CollectionFactory> collectionFactories = new ConcurrentHashMap<String, CollectionFactory>();
    private final Map<String, String> routes = new ConcurrentHashMap<String, String>();
    private String defaultCollectionFactory;

    public void addCollectionFactory(String collectionId, CollectionFactory collectionFactory) {
        this.collectionFactories.put(collectionId, collectionFactory);
    }

    public void addRoute(String collectionName, String collectionId) {
        this.assertCollectionIdExists(collectionId);
        this.routes.put(collectionName, collectionId);
    }

    public void setDefaultRoute(String collectionId) {
        if (collectionId != null) {
            this.assertCollectionIdExists(collectionId);
        }
        this.defaultCollectionFactory = collectionId;
    }

    private void assertCollectionIdExists(String collectionId) {
        if (!this.collectionFactories.containsKey(collectionId)) {
            throw new IllegalArgumentException("The collection " + collectionId + " doesn't exist");
        }
    }

    @Override
    public <T> Collection<T> getCollection(String name, Class<T> entityClass) {
        String collectionId = this.routes.getOrDefault(name, this.defaultCollectionFactory);
        if (collectionId == null) {
            throw new RuntimeException("No route found for collection " + name);
        }
        CollectionFactory collectionFactory = this.collectionFactories.get(collectionId);
        return collectionFactory.getCollection(name, entityClass);
    }

    @Override
    public void close() throws IOException {
        this.collectionFactories.values().forEach(t -> {
            try {
                t.close();
            }
            catch (IOException e) {
                this.logger.error("Error while closing collection factory", (Throwable)e);
            }
        });
    }
}

